<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\User;
use App\Models\UserIp;

class AuthUserController extends Controller
{
    public function getUserBalance(Request $request)
    {
        $jsonData = $request->json()->all();      
        $AuthKey = $request->header('AuthKey');  
        $AuthToken = $request->header('AuthToken');

        $validator = Validator::make($request->all(), [
            'email' => 'required',
            'password' => 'required',            
        ]);

        if($validator->fails()) {
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => $validator->errors(),
            ];
            return response()->json($responseData, 422);
        }
        $user = auth()->user();
        $ipAddress = $request->ip();
        $checkIp = UserIp::where(['userId'=>$user->id,'ipAddress'=>$ipAddress])->first();
        if(empty($checkIp)){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'your ip is not whitlisted, requested ip is '.$ipAddress,
            ];
            return response()->json($responseData , 401);
        }
        if($user){
            return response()->json(["name"=>$user->name,"balance"=>$user->wallet],200);
        }
        return response()->json(["error"=>"Unauthorized"],401);
    }
}
