<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\User;
use App\Models\UserIp;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;

class GenerateTokenController extends Controller
{
    public function generateToken(Request $request)
    {
        $jsonData = $request->json()->all();      
        $AuthKey = $request->header('AuthKey');  
        $AuthToken = $request->header('AuthToken');

        $validator = Validator::make($request->all(), [
            'email' => 'required',
            'password' => 'required',            
        ]);

        if($validator->fails()) {
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => $validator->errors(),
            ];
            return response()->json($responseData, 422);
        }

        $data = [
            'email'=>$request->email,
            'password'=>$request->password,    
            'user_key'=>$AuthKey,
            'user_token'=>$AuthToken,
            'status'=>1,
            'api_status'=>1,
            'user_type'=>1,
            'approved'=>1,
        ];
        
        

    //    if(auth()->attempt($data)){

        if (Auth::attempt($data)) {
          //print_r($data);
            
            // $token->expires_at=Carbon::now()->addDays(7);
            // $token->save();
           
            $user = auth()->user();
            $ipAddress = $request->ip();
            $checkIp = UserIp::where(['userId'=>$user->id,'ipAddress'=>$ipAddress])->first();
            if(empty($checkIp)){
                $responseData = [                
                    'status' => FALSE,
                    'error'=> TRUE,
                    'message' => 'your ip is not whitlisted, requested ip is '.$ipAddress,
                ];
                return response()->json($responseData , 401);
            }
            //  $token = auth()->user()->createToken('Token')->accessToken;
            $token = $user->createToken('Token')->accessToken;
           
            $user = User::where('email', $request->email)->first();
           return response()->json(["name"=>$user->name,"token"=>$token],200);
       
    }
      return response()->json(["error"=>"Unauthorized"],401);

   }



}
