<?php

namespace App\Http\Controllers\API\MYRC;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Carbon;
use App\Models\User;
use App\Models\UserCharge;
use App\Models\UserIp;
use App\Models\UserTransaction;
use App\Models\RechargeModel;
use App\Models\ApiLog;
use App\Models\RechargeCommission;
use App\Models\PayoutModel;

class MobileRecharge extends Controller
{
    public function doMobileRecharge(Request $request)
    {
        $jsonData = $request->json()->all(); 
        $user = auth()->user();
        $validator = Validator::make($request->all(), [
            'opcode' => 'required',
            'number' => 'required',
            'referenceNumber' => 'required|unique:recharge_transactions,orderId',
            'amount' => 'required',
        ]);

        if($validator->fails()) {
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => $validator->errors(),
            ];
            return response()->json($responseData, 422);
        }

        if($user->status != 1 || $user->api_status != 1)
        {
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Invalid credentials',
            ];
            return response()->json($responseData , 401);
        }

        $userId = $user->id;
        $ipAddress = $request->ip();
        $checkIp = UserIp::where(['userId'=>$userId,'ipAddress'=>$ipAddress])->first();
        if(empty($checkIp)){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'your ip is not whitlisted, requested ip is '.$ipAddress,
            ];
            return response()->json($responseData , 401);
        }



        $txn_id = "SSPNR".rand(123121,990999).Carbon::now()->timestamp;
        $username = "503087";
        $token = "59c7349de88c4fcdd56e90339f3e68ee"; 
        $operator = $request['operator'];
        $number = $request['number'];
        $amount = $request['amount'];
        $referenceNumber = $request['referenceNumber'];
        $format = "json";

        $getCommission = RechargeCommission::where('operator',$operator)->where('userId', '=', $userId)->first();
        if(empty($getCommission)){
            $commission = 1;
            $commissionType = "F";
        }else{
            $commission = $getCommission->commission;
            $commissionType = $getCommission->type;
        }

        if($commissionType == "F"){
            $totalCommission= $charge;
        }else if($commissionType == "P"){
            $totalCommission = ($amount*$commission)/100;
        }

        if($operator == "Airtel"){
            $opcode = "A";
        }
        if($operator == "BSNL-TOPUP"){$opcode = "BT";}
        if($operator == "BSNL-STV"){$opcode = "BR";}
        if($operator == "JIO"){$opcode = "RC";}
        if($operator == "Vodafone Idea (VI)"){$opcode = "V";}
        if($operator == "Airtel Digital DTH TV"){$opcode = "ATV";}
        if($operator == "DISH TV"){$opcode = "DTV";}
        if($operator == "SUNDIRECT DTH TV"){$opcode = "STV";}
        if($operator == "TATA PLAY DTH TV"){$opcode = "TTV";}
        if($operator == "VIDEOCON DTH TV"){$opcode = "VTV";}

        

        $totalDeductAmount = $amount-$totalCommission;
        $openBal = $user->wallet;
        $closeBal = $openBal - $totalDeductAmount;                    
        $checkAmount = $totalDeductAmount;

        if($openBal == 0 || $openBal < $checkAmount){           
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Insufficient fund',
            ];
            return response()->json($responseData , 200);
        }

        $UserInstance = new User();
        $UserInstance->deductFund($userId,$totalDeductAmount);

        $remark = "Money Deduct For Recharge ";
        UserTransaction::create([
            'userId' => $userId,
            'txnId' => $txn_id,
            'orderId' => $referenceNumber,
            'type' => "DEBIT",  
            'operator' => "RECHARGE",
            'openBalance' =>$openBal, 
            'amount' => $totalDeductAmount,
            'walletBalance' =>$closeBal,
            'credit' =>0, 
            'debit' =>$totalDeductAmount,
            "status" => "PENDING",
            'remark' => $remark,   
            'api'=>"MYRC",
            'requestIp' => $ipAddress,          
            'created_by' => $userId,
        ]);

        RechargeModel::create([
            'userId' => $userId,
            'txnId' => $txn_id,
            'orderId' => $referenceNumber,
            'amount' => $amount,
            'commission' =>$totalCommission,   
            'totalAmount' => $totalDeductAmount,   
            'operator'=>$operator,
            'mobile' => $number,                  
            'status' => "PENDING",
            'IpAddress' => $ipAddress,
        ]);

        $url = "https://myrc.in/v3/recharge/api?username=503087&token=59c7349de88c4fcdd56e90339f3e68ee&opcode=$opcode&number=$number&amount=$amount&orderid=$txn_id&format=json";
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => $url,
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);

        ApiLog::create([
            'txnId' => $txn_id,
            'request' => $url,
            'response' => $response,  
            'service' => "RECHARGE",
            'service_api' =>"MYRC",   
        ]);

        $responseData = json_decode($response, true);                    
        $status = $responseData['status'];
        $contactId = $responseData['txid'];
        
        if($status == "Success")
        {
            $updateUser = [
                'status' => "SUCCESS"
            ];  

            $UserTransaction = new UserTransaction();      
            $UserTransaction->updateUserTxnData($updateUser,$txn_id);

            $updatePayout = [
                "contactId"=>$contactId,
                "status"=>"SUCCESS",
            ];                  
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updateRecahrgetData($updatePayout,$txn_id);

            $responseData = [
                "status" => "SUCCESS",
                "message" => "Recharge Successfully",
                "data" => array(
                    "referenceNumber" => $referenceNumber,
                    "txn_id" => $txn_id,
                ),
            ];
            return response()->json($responseData , 200);
            die;

        }else if($status == "Failure")
        {
            $updateUser = [
                'status' => "FAILED"
            ];  

            $UserTransaction = new UserTransaction();      
            $UserTransaction->updateUserTxnData($updateUser,$txn_id);

            $updatePayout = [
                "contactId"=>$contactId,
                "status"=>"FAILED",
            ];                  
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updateRecahrgetData($updatePayout,$txn_id);

            $responseData = [
                "status" => "FAILED",
                "message" => "Recharge Failed",
                "data" => array(
                    "referenceNumber" => $referenceNumber,
                    "txn_id" => $txn_id,
                ),
            ];
            return response()->json($responseData , 200);
            die;

        }else{
            $updateUser = [
                'status' => "PROCESSING"
            ];  

            $UserTransaction = new UserTransaction();      
            $UserTransaction->updateUserTxnData($updateUser,$txn_id);

            $updatePayout = [
                "contactId"=>$contactId,
                "status"=>"PROCESSING",
            ];                  
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updateRecahrgetData($updatePayout,$txn_id);

            $responseData = [
                "status" => "PROCESSING",
                "message" => "Recharge In proceess",
                "data" => array(
                    "referenceNumber" => $referenceNumber,
                    "txn_id" => $txn_id,
                ),
            ];
            return response()->json($responseData , 200);
            die;
        }

    }
}