<?php

namespace App\Http\Controllers\API\PAYOUT;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Carbon;
use App\Models\User;
use App\Models\UserCharge;
use App\Models\UserIp;
use App\Models\UserTransaction;
use App\Models\PayinModel;
use App\Models\PayoutModel;
use App\Models\ApiLog;
use Illuminate\Support\Facades\Http;
use Illuminate\Http\Client\RequestException;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;

class PayoutfControllernew extends Controller
{
    public function generatefliptoken(){
     
$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://payout.flipzik.com/genToken',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS =>'{
    "email": "abhishekchanchal133@gmail.com",
    "password": "Mapp@112233"
}',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
//echo $response;


$responseData = json_decode($response, true);
    
       
if ($responseData === null && json_last_error() !== JSON_ERROR_NONE) {
    $error = 'JSON decoding error: ' . json_last_error_msg();
    echo 'Token retrieval error: ' . $error;
    return ['error' => 'Failed to parse API response'];
}

if (isset($responseData['token'])) {
    return $responseData['token']; // Return the token directly
} else {
    $error = isset($responseData['error']) ? $responseData['error'] : 'Unknown error';
    echo 'Token retrieval error: ' . $error;
    return ['error' => 'Token not found in API response'];
}
}


    public function transferflipfund(Request $request){
        
           Log::info('Transfer fund request received', [
        'request_data' => $request->all()
    ]);


        $jsonData = $request->json()->all();  
       $AuthKey = $request->header('AuthenticatedKeyId');  
        $AuthToken = $request->header('AuthenticatedToken');
        $AuthCode = $request->header('AuthenticatedCode');
        

 
        $validator = Validator::make($request->all(), [
        'name' => 'required|string',
        'mobileNumber' => 'required',
        'referenceNumber' =>'required|unique:payout_transactions,orderId',
        'transferAmount' => 'required',
        'transferMode' => 'required',
        
    ]);


    if($validator->fails()) {
        
        Log::error('Validation failed', [
        'errors' => $validator->errors()->toArray(),
    ]);
        $responseData = [                
            'status' => FALSE,
            'error'=> TRUE,
            'message' => $validator->errors(),
        ];
        return response()->json($responseData, 422);
        
    }
        
      

        $getUser = User::where("user_token",$AuthToken)->where("user_key",$AuthKey)->where("status",1)->where("api_status",1)->where("user_type",1)->where("approved",1)->first();
        $address = $getUser->city;
        if(empty($getUser)){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Invalid credentials',
            ];
            return response()->json($responseData , 401);
        }
        if (Hash::check($AuthCode, $getUser->authCode)) {

        }else{
            
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Invalid credentials!',
            ];
            return response()->json($responseData , 401);
            die;
        }
        $userId = $getUser->id;
        $api_status = $getUser->api_status;
        if($api_status == 0){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'We are taking downtime due to some technical issues. Please wait till further update',
            ];
            return response()->json($responseData , 200);die;
        }
        $bank_deactive = $getUser->bank_deactive;
        if($bank_deactive == 1){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Your API has been Deactivated by the Bank due to security reasons.',
            ];
            return response()->json($responseData , 200);die;
        }
        $tecnical_issue = $getUser->tecnical_issue;
        if($tecnical_issue == 1){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'We are facing technical issue from bank side.',
            ];
            return response()->json($responseData , 200);die;
        }

      

        $ipAddress = $request->ip();
        $checkIp = UserIp::where(['userId'=>$userId,'ipAddress'=>$ipAddress])->first();
        if(empty($checkIp)){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'your ip is not whitlisted, requested ip is '.$ipAddress,
            ];
            return response()->json($responseData , 401);die; }
            
    $referenceNumber =$request['referenceNumber'];
    $merchantId = "SEOS".rand(123121,990999).Carbon::now()->timestamp;
    $name = $request['name'];
    $mobile = $request['mobileNumber'];
    $transferAmount = $request['transferAmount'];
     $transfermode = $request['transferMode'];
      $accountNumber = $request['accountNumber'];
      $ifscCode = $request['bankIfsc'];
      $bankname= $request['beneBankName'];
     // $checkaccountno = $request['reenter_accno'];
      $vpa = $request['vpa'];
    

        
        if($transfermode == 'IMPS') {
            if($getUser->IMPS == 1) {

                $validator = Validator::make($request->all(), [
                    'accountNumber' => 'required|string',
                    'bankIfsc' => 'required|string',
                    'beneBankName' => 'required|string',
                   
                ]);
    
                if ($validator->fails()) {
                    $responseData = [
                        'status' => FALSE,
                        'error' => TRUE,
                        'message' => $validator->errors(),
                    ];
                    return response()->json($responseData, 422);
                }
                
                 $requestData = [
        "name" => $name,
        //"email" => "abhishekchanchal133@gmail.com",
         "email" => "shikuldigitalservices@gmail.com",
        "mobile_number" => $mobile,
        "address" => $address,
        "payment_method" => $transfermode,
        "bank_name" => $bankname,
        "account_number" => $accountNumber,
        "amount" => $transferAmount,
        "merchant_order_id" => $merchantId,
        "ifsc" => $ifscCode
    ];
      $url = "https://payout.flipzik.com/payout/transfer";
            }else {
                $responseData = [
                    'status' => FALSE,
                    'error'=> TRUE,
                    'message' => 'IMPS not permitted',
                ];
                return response()->json($responseData, 200);die;
            }}
         
        elseif($transfermode == 'UPI') {
            if($getUser->UPI == 1) {

                $validator = Validator::make($request->all(), [
                    'vpa' => 'required|string',
                ]);
    
                if ($validator->fails()) {
                    $responseData = [
                        'status' => FALSE,
                        'error' => TRUE,
                        'message' => $validator->errors(),
                    ];
                    return response()->json($responseData, 422);
                }
                
                  $requestData = [
           
        "name" => $name,
        //"email" => "abhishekchanchal133@gmail.com",
         "email" => "shikuldigitalservices@gmail.com",
        "mobile_number" => $mobile,
        "address" => $address,
        "payment_method" => $transfermode,
        "bank_name" => "Yes Bank",
        "account_number" =>  $vpa,
        "amount" => $transferAmount,
        "merchant_order_id" => $merchantId,
        "ifsc" => " "
        ];
         $url = "https://payout.flipzik.com/payout/transfer";
    }
    
     else {
                $responseData = [
                    'status' => FALSE,
                    'error'=> TRUE,
                    'message' => 'UPI not permitted',
                ];
                return response()->json($responseData, 200);die;
            }
        } 
        else {
            $responseData = [
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Invalid transfer mode',
            ];
            return response()->json($responseData, 200);
            die;
        }
        
         DB::beginTransaction();

        try {
            $getUser = DB::table('users')->where('id', $getUser->id)->lockForUpdate()->first();
        
        $getCommission = UserCharge::where('start_amount', '<=', $transferAmount)->where('end_amount', '>=', $transferAmount)->where('userId', '=', $userId)->first();
        if(empty($getCommission)){
            $charge = 20;
            $chargeType = "F";
        }else{
            $charge = $getCommission->payout_charge;
            $chargeType = $getCommission->payout_charge_type;
        }
        $gst = 18;
        if($chargeType == "F"){
            $totalCharge = $charge;
            $totalGst = ($totalCharge*$gst)/100;
        }else if($chargeType == "P"){
            $totalCharge = ($transferAmount*$charge)/100;
            $totalGst = ($totalCharge*$gst)/100;
        }
        $totalDeductAmount = $transferAmount +$totalCharge+$totalGst;
        $openBal = $getUser->wallet;
        $lien =$getUser->lien;
        $rolling_reserve = $getUser->rolling_reserve;
        $closeBal = $openBal - $totalDeductAmount;                    
        $checkAmount = $totalDeductAmount+$lien+$rolling_reserve;

        if($openBal == 0 || $openBal < $checkAmount){  
             DB::rollBack();   
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Insufficient fund',
            ];
            return response()->json($responseData , 200);
            die;
        }
        
        $UserInstance = new User();
        $UserInstance->deductFund($userId,$totalDeductAmount);

        $remark = "Money Transfer Via Payout ";
        UserTransaction::create([
            'userId' => $userId,
            'txnId' => $merchantId,
             'orderId' => $referenceNumber,
            'type' => "DEBIT",  
            'operator' => "PAYOUT",
            'openBalance' =>$openBal, 
            'amount' => $totalDeductAmount,
            'walletBalance' =>$closeBal,
            'credit' =>0, 
            'debit' =>$totalDeductAmount,
            "status" => "PENDING",
            'remark' => $remark,   
            'api'=>"FLIPZIK",
            'requestIp' => $ipAddress,          
            'created_by' => $userId,
        ]);

        PayoutModel::create([
            'userId' => $userId,
            'txnId' => $merchantId,
            'orderId' => $referenceNumber,
            'amount' => $transferAmount,
            'charge' =>$totalCharge,   
            'gst'=>$totalGst,
            'totalAmount' => $totalDeductAmount,   
            'mode'=>$transfermode,
            'beneName' => $name,          
            'beneBank' => $bankname,
            'beneAccount' => $accountNumber,   
            'beneIfsc' => $ifscCode,          
            'status' => "PENDING",
            'api'=>"FLIPZIK",
            'IpAddress' => $ipAddress,
            'mobile' =>$mobile,
            'contactId' => $vpa,
        ]);

        $headers = [
    'Accept: application/json',
    //'Authorization: Bearer 79|xCF8RGY38WY77kCScZZA5gG2FJSnISovYux8qSk7757b7aa1',
    'Authorization: Bearer 81|lyOCxP4MUghloMf8kguTfzbW9QnotGqqWACvaa6C1e643558',
    'api-key: ak_8lpjsq9dhdwfibmp9ko9',
    //'api-key: ak_urtc0dhzgkpu4oj7ww6v',   
    'Content-Type: application/json'
];
  

    $payload = json_encode($requestData);
   // print_r($payload);
   
  Log::info('Request:', ['request' => $payload]);


    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://payout.flipzik.com/payout/transfer',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $payload,
        CURLOPT_HTTPHEADER => $headers,
    ));

    $response = curl_exec($curl);
     
    curl_close($curl);
    
     Log::info('Response:', ['response' => $response]);

   if ($response === false) {
    $error = curl_error($curl);
    Log::error('cURL error', [
        'error' => $error,
        'request' => $payload,
        
    ]);
    // return response()->json([
    //     'status' => 'Failed',
    //     'message' => 'An error occurred while processing your request. Please try again later.'
    // ], 500);
}



 $responseData = json_decode($response, true); 
if (isset($responseData['status']) && $responseData['status'] === false) {
    Log::error('API error', [
        'message' => $responseData['message'],
        'response' => $responseData,
        'request' => $payload
    ]);
    // return response()->json([
    //     'status' => 'Failed',
    //     'message' => $responseData['message'] ?? 'An error occurred with the API.'
    // ], 500);
}
 

 
        ApiLog::create([
            'txnId' => $merchantId,
            'request' => $payload,
            'response' => $response,  
            'service' => "PAYOUT",
            'service_api' =>"FLIPZIK",   
        ]);
        
  


    //   print_r($responseData);
        
         $status1 = isset($responseData['message'])?$responseData['message']:'';
        $data = $responseData['data'];
      

        $status = $data['status'];
       //$merchantId = $data['merchant_order_id'] ?? ''; // Use null coalescing operator to handle missing key
        $clientgatewayid = isset($data['gateway_id'])?$data['gateway_id'] : ''; 
        $clientutr = isset($data['utr'] )?$data['utr'] :''; 
        

     
           if($status == "Failed" || $status1 == "Bank Error"){
            $updateUser = [
                'walletBalance' =>$openBal,
                'status' => "FAILED"
            ];  

            $UserTransaction = new UserTransaction();      
            $UserTransaction->updateUserTxnData($updateUser,$merchantId);

            $updatePayout = [
                "payoutId"=> $clientgatewayid,  
                 "utr"=> $clientutr,
                "status"=>"FAILED",
                //"remark"=>$status
            ];                  
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updatePayoutData($updatePayout,$merchantId);

            //$user = User::findOrFail($userId);
            $UserInstance = new User();
            $UserInstance->addFund($userId,$totalDeductAmount);

        //   $responseData = [
        //           "status" => "Failed",
        //           "name" => $name,
        //           "number" => $mobile,
        //           "amount" => $transferAmount,
        //             "clientid" => $referenceNumber,
        //             "txnid" => $merchantId,
        //             "utr" => $clientutr,

               
        //     ];
            
              $responseData = [
                "status" => "FAILED",
    
                "message"=>"Transaction is Failed",
                "data" => array(
                    "payout_ref" => $referenceNumber,
                    "txn_id" => $merchantId,
                    "bank_ref" => $clientutr,
                ),
            ];
            DB::commit();
            return response()->json($responseData, 200);
        }

        if($status == "Success") {
         

            $updateUser = [
                'status' => "SUCCESS"
            ];  

            $UserTransaction = new UserTransaction();      
            $UserTransaction->updateUserTxnData($updateUser,$merchantId);

            $updatePayout = [
                
                "utr"=> $clientutr,
                "payoutId"=> $clientgatewayid,    
                "status"=>"SUCCESS",
                
               // "remark"=>$statusMessage
            ];                  
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updatePayoutData($updatePayout,$merchantId);

            
        //   $responseData = [
        //           "status" => "Success",
        //           "name" => $name,
        //           "number" => $mobile,
        //           "amount" => $transferAmount,
        //             "clientid" => $referenceNumber,
        //             "txnid" => $merchantId,
        //             "utr" => $clientutr,
        //     ];
        
        $responseData = [
                "status" => "SUCCESS",
                "message" => "Transaction is Successful",
                "data" => array(
                   "payout_ref" => $referenceNumber,
                    "txn_id" => $merchantId,
                    "bank_ref" => $clientutr
                ),
            ];
            DB::commit();
            return response()->json($responseData, 200);
        }
        
          if($status == "Pending") {
     
         $responseData = [
                "status" => "Pending",
                 "message" => "Transaction is Pending",
                "data" => array(
                   "payout_ref" => $referenceNumber,
                    "txn_id" => $merchantId,
                    "bank_ref" => ""
                ),
            ];
            DB::commit();
            return response()->json($responseData, 200);
        }
        
        }catch (\Exception $e) {
       
        Log::error('Transaction rollback', [
            'userId' => $getUser->id ?? null,
            'requestData' => $request->all(),
            'exceptionMessage' => $e->getMessage(),
            'exceptionTrace' => $e->getTraceAsString(),
            'timestamp' => now(),
        ]);
        
        
        DB::rollBack();
         
          
        return response()->json([
            'status' => FALSE,
            'error' => TRUE,
            'message' => 'Transaction failed. Please try again.',
           // 'details' => $e->getMessage()
        ], 500);
    }
   
        }
        
        
    
    



public function callbackurl(Request $request){
    
$jsonData = $request->json()->all();

Log::info('Incoming callback data: ' . json_encode($jsonData));

    // Extract status and utr from the data
    $status = $jsonData['data']['status'] ?? null;
    $utr = isset($jsonData['data']['utr'])?$jsonData['data']['utr'] : null;
    $merchantId = isset($jsonData['data']['merchant_order_id'])?$jsonData['data']['merchant_order_id']:null;
    $clientgatewayidcallback = isset($jsonData['data']['gateway_id'])?$jsonData['data']['gateway_id'] :null;
            
  
         
          DB::beginTransaction();
    try {
        $pendingPayout = PayoutModel::where('txnId', $merchantId)->lockForUpdate()->first();
 
     $pendingstatus =    $pendingPayout->status;
     
     if($pendingstatus=="PENDING"){

        $userTransaction = UserTransaction::where('txnId', $merchantId)->lockForUpdate()->first();
       
         
          if($status == "Failed" || $status == "Bank Error"){
              
      
            //$userId = $userTransaction->userId;
           // $openBal = $userTransaction->openBalance;
            
     // $totalDeductAmount = $userTransaction->debit;
            
            $updateUser = [
                //'walletBalance' =>$openBal,
                'status' => "FAILED"
            ];  

            $UserTransaction = new UserTransaction();      
            $UserTransaction->updateUserTxnData($updateUser,$merchantId);

            $updatePayout = [
                "payoutId"=> $clientgatewayidcallback,          
                "status"=>"FAILED",
                 "utr"=> $utr,
                //"remark"=>$status
            ];                  
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updatePayoutData($updatePayout,$merchantId);

            //$user = User::findOrFail($userId);
            // $UserInstance = new User();
            // $UserInstance->addFund($userId,$totalDeductAmount);
           
        }
        

        if($status == "Success") {
         
            $updateUser = [
                'status' => "SUCCESS"
            ];  

            $UserTransaction = new UserTransaction();      
            $UserTransaction->updateUserTxnData($updateUser,$merchantId);

            $updatePayout = [
                
                "utr"=> $utr,
                "payoutId"=> $clientgatewayidcallback,    
                "status"=>"SUCCESS",
              // "remark"=>$statusMessage
            ];                  
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updatePayoutData($updatePayout,$merchantId);
}

}
DB::commit();
} catch (\Exception $e) {
  
    Log::error('Callback error: ' . $e->getMessage());
      DB::rollBack();
}

         $this->callbackurlgive($request);
}

public function callbackurlgive(Request $request){
    
     $jsonData = $request->json()->all();

    Log::info('Incoming callback data2: ' . json_encode($jsonData));

    // Extract status and utr from the data
     $amount = $jsonData['data']['amount'] ?? null;
     $merchantId = $jsonData['data']['merchant_order_id'] ?? null;
    $payment_method = $jsonData['data']['payment_method'] ?? null;
    $customer_name = $jsonData['data']['customer_name'] ?? null;
      $customer_ifsc = $jsonData['data']['customer_ifsc'] ?? null;
   $customer_account_number  = $jsonData['data']['customer_account_number'] ?? null;
   $customer_mobile = $jsonData['data']['customer_mobile'] ?? null;
     $updated_at = $jsonData['data']['updated_at'] ?? null;
      $created_at = $jsonData['data']['created_at'] ?? null;
    $status = $jsonData['data']['status'] ?? null;
    $utr = $jsonData['data']['utr'] ?? null;
    
     $userTransaction = UserTransaction::where('txnId', $merchantId)->first();
      if ($userTransaction){

    $orderid = $userTransaction->orderId;

      
     

    // Create the final response format
    $responseData = [
        "amount" => $amount,
        "merchant_order_id" => $merchantId,
        "Reference_id" => $orderid,
        "status" => $status,
        "utr" => $utr,
      
    ];

    // Log response data
    Log::info('Response data: ' . json_encode($responseData));

    // Prepare final response data
    $finalResponse = [
        "data" => $responseData,
    ];

    // Log final response data
    Log::info('Final response: ' . json_encode($finalResponse));

    // If the user transaction exists, proceed
    
        $userId = $userTransaction->userId;
        $user = User::find($userId);

        // If the user exists and has a payout callback URL, send the response
        if ($user && $user->payout_callback) {
            $userURL = $user->payout_callback;

            // Send POST request to the user's callback URL
            $response = Http::post($userURL, $finalResponse);

            // Log the response
            Log::info('Response sent to user URL: ' . json_encode($finalResponse));
            Log::info('Response body from user URL: ' . $response->body());
        }
        else{
            Log::info('no callback url found');
        }
    }
}
    
    


  public function checkStatus(Request $request){

        $jsonData = $request->json()->all();        
        $Authorization = $request->header('Authorization');

        $validator = Validator::make($request->all(), [
            'referenceNumber' => 'required',            
        ]);

        if($validator->fails()) {
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => $validator->errors(),
            ];
            return response()->json($responseData, 422); die;
        }

        $getUser = User::where("user_token",$Authorization)->where("status",1)->where("api_status",1)->where("user_type",1)->first();
        if(empty($getUser)){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Invalid credentials.',
            ];
            return response()->json($responseData , 401); die;
        }

        $userId = $getUser->id;
        $ipAddress = $request->ip();
        // $checkIp = UserIp::where(['userId'=>$userId,'ipAddress'=>$ipAddress])->first();
        // if(empty($checkIp)){
        //     $responseData = [                
        //         'status' => FALSE,
        //         'error'=> TRUE,
        //         'message' => 'your ip is not whitlisted, requested ip is '.$ipAddress,
        //     ];
        //     return response()->json($responseData , 401);
        // }
        $referenceNumber = $request['referenceNumber'];
  
        $checkTxn = PayoutModel::where("orderId",$referenceNumber)->where("userId",$userId)->where("api","FLIPZIK")->get()->toArray();
     
        if(empty($checkTxn)){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Transaction not found.',
            ];
            return response()->json($responseData , 200); die;
        }
        
        $TxnStatus = $checkTxn[0]['status'];
        $TxnApi = $checkTxn[0]['api'];
        $txnId = $checkTxn[0]['txnId'];
      
      $url = "https://status.flipzik.com/payout/status/$txnId";
     
        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            //CURLOPT_POSTFIELDS => $payload,
            CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            //  'Authorization: Bearer 79|xCF8RGY38WY77kCScZZA5gG2FJSnISovYux8qSk7757b7aa1'
             'Authorization: Bearer 81|lyOCxP4MUghloMf8kguTfzbW9QnotGqqWACvaa6C1e643558',
        ),
        ]);

       $response = curl_exec($curl);
       //echo $response;
        $err = curl_error($curl);
        curl_close($curl);

        ApiLog::create([
            'txnId' => $txnId,
            'request' => $referenceNumber,
            'response' => $response,  
            'service' => "CHECKSTATUS",
            'service_api' =>"FLIPZIK",   
        ]);

        if (empty($response)) {
            $response = [
                'status'   => 400,
                'error'    => true,
                'messages' => 'Something went wrong'
            ];
            return $this->respond($response, 400);
        }

        $jsonData = json_decode($response, true);

    $status = $jsonData['data']['status'] ?? null;
    $utr = $jsonData['data']['utr'] ?? null;
    $merchantId = $jsonData['data']['merchant_order_id'] ?? null;
    $clientgatewayidcallback = $jsonData['data']['gateway_id'] ?? null;
            
             $pendingPayout = PayoutModel::where('txnId', $merchantId)->first();    
     $pendingstatus =    $pendingPayout->status;
     
    
     
     if($pendingstatus=="PENDING"){
          if($status == "Failed" || $status == "Refund"){
              
        $userTransaction = UserTransaction::where('txnId', $merchantId)->first();
        if ($userTransaction) {
            
            $updateUser = [
               
                'status' => "FAILED"
            ];  

            $UserTransaction = new UserTransaction();      
            $UserTransaction->updateUserTxnData($updateUser,$merchantId);

            $updatePayout = [
                "payoutId"=> $clientgatewayidcallback,          
                "status"=>"FAILED",
                 "utr"=> $utr,
               
            ];                  
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updatePayoutData($updatePayout,$merchantId);

        }
        }

        if($status == "Success") {
         

            $updateUser = [
                'status' => "SUCCESS"
            ];  

            $UserTransaction = new UserTransaction();      
            $UserTransaction->updateUserTxnData($updateUser,$merchantId);

            $updatePayout = [
                
                "utr"=> $utr,
                "payoutId"=> $clientgatewayidcallback,    
                "status"=>"SUCCESS",
              
            ];                  
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updatePayoutData($updatePayout,$merchantId);
        
        
            
    }
    
     }
  $responseData = [
            "status" => $status,
            "message" => "Transaction is $status",
            "data" => array(
                "payout_ref" => $referenceNumber,
                "txnId" => $txnId,
                "bank_ref" => $utr
            ),
        ];
     
       return response()->json($responseData , 200);
  

}


}
