<?php
namespace App\Http\Controllers\API\Payoutapidm;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Carbon;
use App\Models\User;
use App\Models\UserCharge;
use App\Models\UserIp;
use App\Models\UserTransaction;
use App\Models\PayinModel;
use App\Models\PayoutModel;
use App\Models\ApiLog;
use Illuminate\Support\Facades\Http;
use Illuminate\Http\Client\RequestException;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Cache;

class PayoutdmapiController extends Controller
{


    public function transferflipfund(Request $request){
    $jsonData = $request->json()->all();  
    $AuthKey = $request->header('AuthenticatedKeyId');  
    $AuthToken = $request->header('AuthenticatedToken');
    $AuthCode = $request->header('AuthenticatedCode');
    


    $validator = Validator::make($request->all(), [
    'name' => 'required|string',
    'mobileNumber' => 'required|numeric',
    'referenceNumber' =>'required|unique:payout_transactions,orderId',
    'transferAmount' => 'required|numeric',
    'beneBankName' => 'required',
    'accountNumber' => 'required',
    'bankIfsc' => 'required',
    'transferMode' => 'required',
]);

if($validator->fails()) {
    $responseData = [                
        'status' => FALSE,
        'error'=> TRUE,
        'message' => $validator->errors(),
    ];
    return response()->json($responseData, 422);
}
    
  

    $getUser = User::where("user_token",$AuthToken)->where("user_key",$AuthKey)->where("status",1)->where("api_status",1)->where("user_type",1)->where("approved",1)->first();
    $address = $getUser->city;
    if(empty($getUser)){
        $responseData = [                
            'status' => FALSE,
            'error'=> TRUE,
            'message' => 'Invalid credentials',
        ];
        return response()->json($responseData , 401);
    }
    if (Hash::check($AuthCode, $getUser->authCode)) {

    }else{
        $responseData = [                
            'status' => FALSE,
            'error'=> TRUE,
            'message' => 'Invalid credentials!',
        ];
        return response()->json($responseData , 401);
        die;
    }
    $userId = $getUser->id;
    $api_status = $getUser->api_status;
    if($api_status == 0){
        $responseData = [                
            'status' => FALSE,
            'error'=> TRUE,
            'message' => 'We are taking downtime due to some technical issues. Please wait till further update',
        ];
        return response()->json($responseData , 200);die;
    }
    $bank_deactive = $getUser->bank_deactive;
    if($bank_deactive == 1){
        $responseData = [                
            'status' => FALSE,
            'error'=> TRUE,
            'message' => 'Your API has been Deactivated by the Bank due to security reasons.',
        ];
        return response()->json($responseData , 200);die;
    }
    $tecnical_issue = $getUser->tecnical_issue;
    if($tecnical_issue == 1){
        $responseData = [                
            'status' => FALSE,
            'error'=> TRUE,
            'message' => 'We are facing technical issue from bank side.',
        ];
        return response()->json($responseData , 200);die;
    }

    $flipzik = $getUser->flipzik;
    if($flipzik != 1){
        $responseData = [                
            'status' => FALSE,
            'error'=> TRUE,
            'message' => 'This service is not active at this time.',
        ];
        return response()->json($responseData , 200);die;
    }
    


    $ipAddress = $request->ip();
    $checkIp = UserIp::where(['userId'=>$userId,'ipAddress'=>$ipAddress])->first();
    if(empty($checkIp)){
        $responseData = [                
            'status' => FALSE,
            'error'=> TRUE,
            'message' => 'your ip is not whitlisted, requested ip is '.$ipAddress,
        ];
        return response()->json($responseData , 401);
    }
$referenceNumber =$request['referenceNumber'];
$merchantId = "VMD".rand(123121,990999).Carbon::now()->timestamp;
$name = $request['name'];
$mobile = $request['mobileNumber']; 
$bankName = $request['beneBankName'];
$accountNumber = $request['accountNumber'];
$transferAmount = $request['transferAmount'];
 $transfermode = $request['transferMode'];
$ifscCode = $request['bankIfsc'];


    if($userId != 29)
    {
        if($ifscCode == "AIRP0000001" || $ifscCode == "PYTM0123456")
        {
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Transaction not allowed in this bank',
            ];
            return response()->json($responseData , 401);
            die;
        }
    }
    
    if($transfermode == 'IMPS') {
        if($getUser->IMPS == 1) {
            $requestData = [
                "token" =>"GoYNcSpZepmx6HSjq58K7On4OqxKnx",
                "name" => $name,
                "type" => "bank",
                "email" => "abhishekchanchal133@gmail.com",
                "mobile" => $mobile,
                "address" => $address,
                "mode" => $transfermode,
                "bank" => $bankName,
                "account" => $accountNumber,
                "amount" => $transferAmount,
                "apitxnid" => $merchantId,
                "ifsc" => $ifscCode
            ];
        } else {
            $responseData = [
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'IMPS not permitted',
            ];
            return response()->json($responseData, 200);die;
        }
    } elseif($transfermode == 'UPI') {
        if($getUser->UPI == 1) {
            $requestData = [
                "token" =>"",
                "name" => $name,
                "type" => "bank",
                "email" => "abhishekchanchal133@gmail.com",
                "mobile" => $mobile,
                "address" => $address,
                "mode" => $transfermode,
                "bank" => $bankName,
                "account" => $accountNumber,
                "amount" => $transferAmount,
                "apitxnid" => $merchantId,
                "ifsc" => $ifscCode
            ];
        } else {
            $responseData = [
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'UPI not permitted',
            ];
            return response()->json($responseData, 200);die;
        }
    } else {
        $responseData = [
            'status' => FALSE,
            'error'=> TRUE,
            'message' => 'Invalid transfer mode',
        ];
        return response()->json($responseData, 200);
        die;
    }

    $getCommission = UserCharge::where('start_amount', '<=', $transferAmount)->where('end_amount', '>=', $transferAmount)->where('userId', '=', $userId)->first();
    if(empty($getCommission)){
        $charge = 20;
        $chargeType = "F";
    }else{
        $charge = $getCommission->payout_charge;
        $chargeType = $getCommission->payout_charge_type;
    }
    $gst = 18;
    if($chargeType == "F"){
        $totalCharge = $charge;
        $totalGst = ($totalCharge*$gst)/100;
    }else if($chargeType == "P"){
        $totalCharge = ($transferAmount*$charge)/100;
        $totalGst = ($totalCharge*$gst)/100;
    }
    $totalDeductAmount = $transferAmount +$totalCharge+$totalGst;
    $openBal = $getUser->wallet;
    $lien =$getUser->lien;
    $rolling_reserve = $getUser->rolling_reserve;
    $closeBal = $openBal - $totalDeductAmount;                    
    $checkAmount = $totalDeductAmount+$lien+$rolling_reserve;

    if($openBal == 0 || $openBal < $checkAmount){           
        $responseData = [                
            'status' => FALSE,
            'error'=> TRUE,
            'message' => 'Insufficient fund',
        ];
        return response()->json($responseData , 200);
        die;
    }
    
    $UserInstance = new User();
    $UserInstance->deductFund($userId,$totalDeductAmount);

    $remark = "Money Transfer Via Payout ";
    UserTransaction::create([
        'userId' => $userId,
        'txnId' => $merchantId,
         'orderId' => $referenceNumber,
        'type' => "DEBIT",  
        'operator' => "PAYOUT",
        'openBalance' =>$openBal, 
        'amount' => $totalDeductAmount,
        'walletBalance' =>$closeBal,
        'credit' =>0, 
        'debit' =>$totalDeductAmount,
        "status" => "PENDING",
        'remark' => $remark,   
        'api'=>"DMV",
        'requestIp' => $ipAddress,          
        'created_by' => $userId,
    ]);

    PayoutModel::create([
        'userId' => $userId,
        'txnId' => $merchantId,
        'orderId' => $referenceNumber,
        'amount' => $transferAmount,
        'charge' =>$totalCharge,   
        'gst'=>$totalGst,
        'totalAmount' => $totalDeductAmount,   
        'mode'=>$transfermode,
        'beneName' => $name,          
        'beneBank' => $bankName,
        'beneAccount' => $accountNumber,   
        'beneIfsc' => $ifscCode,          
        'status' => "PENDING",
        'api'=>"DMV",
        'IpAddress' => $ipAddress,
        'mobile' => $mobile,
    ]);

   
$payload = json_encode($requestData);
// print_r($payload);

$curl = curl_init();

curl_setopt_array($curl, array(
    CURLOPT_URL => 'https://uat.dmvsoftech.com/api/payout/transaction',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'POST',
    CURLOPT_POSTFIELDS => $payload,
    CURLOPT_HTTPHEADER => array(
        'Content-Type: application/json'
    ),
));

$response = curl_exec($curl);

if ($response === false) {
    $error = curl_error($curl);
    // Handle cURL error
    echo "cURL Error: " . $error; die();
} else {
    $responseData = json_decode($response, true);
    if (isset($responseData['status']) && $responseData['status'] === false) {
        // Handle API error response
        echo "API Error: " . $responseData['message'];die();
    } else {
        // Process successful response
         echo $response; die();
    }
}
curl_close($curl);


    ApiLog::create([
        'txnId' => $merchantId,
        'request' => $payload,
        'response' => $response,  
        'service' => "PAYOUT",
        'service_api' =>"FLIPZIK",   
    ]);

    $responseData = json_decode($response, true); 
    $data = $responseData['data'];
  

    $status = $data['status'];
   //$merchantId = $data['merchant_order_id'] ?? ''; // Use null coalescing operator to handle missing key
    $clientgatewayid = $data['gateway_id'] ?? ''; // Use null coalescing operator to handle missing key
    $clientutr = $data['utr'] ?? ''; 
    

 
    


       if($status == "Failed"){
        $updateUser = [
            'walletBalance' =>$openBal,
            'status' => "FAILED"
        ];  

        $UserTransaction = new UserTransaction();      
        $UserTransaction->updateUserTxnData($updateUser,$merchantId);

        $updatePayout = [
            "payoutId"=> $clientgatewayid,  
             "utr"=> $clientutr,
            "status"=>"FAILED",
            //"remark"=>$status
        ];                  
        $PayoutModel = new PayoutModel();      
        $PayoutModel->updatePayoutData($updatePayout,$merchantId);

        //$user = User::findOrFail($userId);
        $UserInstance = new User();
        $UserInstance->addFund($userId,$totalDeductAmount);

        $responseData = [
            "status" => "FAILED",
            // "message" => $status,
            "message"=>"Transaction is Failed",
            "data" => array(
                "payout_ref" => $referenceNumber,
                "txn_id" => $merchantId,
                "bank_ref" => $clientutr,
            ),
        ];
        return response()->json($responseData , 200);
        die;
    }

    if($status == "Success") {
     

        $updateUser = [
            'status' => "SUCCESS"
        ];  

        $UserTransaction = new UserTransaction();      
        $UserTransaction->updateUserTxnData($updateUser,$merchantId);

        $updatePayout = [
            
            "utr"=> $clientutr,
            "payoutId"=> $clientgatewayid,    
            "status"=>"SUCCESS",
            
           // "remark"=>$statusMessage
        ];                  
        $PayoutModel = new PayoutModel();      
        $PayoutModel->updatePayoutData($updatePayout,$merchantId);

        $responseData = [
            "status" => "SUCCESS",
            "message" => "Transaction is Successful",
            "data" => array(
               "payout_ref" => $referenceNumber,
                "txn_id" => $merchantId,
                "bank_ref" => $clientutr
            ),
        ];
        return response()->json($responseData , 200);
        die;
    }
    
      if($status == "Pending") {
 
    
      $responseData = [
            "status" => "Pending",
             "message" => "Transaction is Pending",
            "data" => array(
               "payout_ref" => $referenceNumber,
                "txn_id" => $merchantId,
                "bank_ref" => ""
            ),
        ];
        return response()->json($responseData , 200);
        die;
    
    
      }

   $responseData = [
      
        "status" => $status,
        "message" => $msg,
        "data" => array(
           
            "txn_id" => $merchantId,
            "bank_ref" => "",
           
        ),
    ];
    return response()->json($responseData , 200);
    die;

}
}

