<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\AuthController;
use App\Http\Controllers\API\GenerateTokenController;
use App\Http\Controllers\API\AuthUserController;
use App\Http\Controllers\API\ISERVEU\PayoutController;
use App\Http\Controllers\API\ISERVEU\PayinController;
use App\Http\Controllers\API\MYRC\MobileRecharge;
use App\Http\Controllers\API\WAAYUPAY\Waayupayout;
use App\Http\Controllers\API\YESBANK\YESBANKController;
use App\Http\Controllers\API\AxisBank\AxisbankController;
use App\Http\Controllers\API\Payoutapidm\PayoutdmapiController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::post('register/g1/user',[AuthController::class,'registerUser']);
Route::post('login/g1/user',[AuthController::class,'login']);

Route::post('new/generateToken',[GenerateTokenController::class,'generateToken']);
//Route::post('new/v1/payin/callback',[PayinController::class,'payinCallback']);

Route::middleware('auth:api')->group(function(){
    //Route::post('user-info',[AuthController::class,'profile']);
    Route::post('new/user-check-balance',[AuthUserController::class,'getUserBalance']);
    //Route::post('new/v1/payout/docashtransfer',[PayoutController::class,'doPayout']);
    Route::post('new/v1/payin/genratePaymentLink',[PayinController::class,'generatePaymentLink']);
    Route::post('new/v1/recharge/doRecharge',[MobileRecharge::class,'doMobileRecharge']);
    

    //flipzik
    Route::middleware('check.api.availability')->group(function () {
       //Route::post('new/v1/payout/docashtransfer', [AxisbankController::class, 'transferfund']);
        //Route::post('new/v1/payout/docashtransfer', [YESBANKController::class, 'transferflipfund']);
        Route::post('new/v1/payout/docashtransfer', [PayoutdmapiController::class, 'transferflipfund']);
    });  
});

// Route::post('PayoutAPI/Payoutnotify', [AxisbankController::class, 'callbackurl']);
// Route::post('new/v4/payout/checkstatus', [AxisbankController::class, 'checkStatus']);


Route::get('/bring/down', [YESBANKController::class, 'bringDown']);
Route::get('/bring/up', [YESBANKController::class, 'bringUp']);

// Route::post('/process-transactions', [YESBANKController::class, 'processTransactions']);

//flipzik callback
Route::post('v1/callback/flipzik/payout', [YESBANKController::class, 'callbackurl']);
Route::post('v1/generatetoken/flipzik/payout', [YESBANKController::class, 'generatefliptoken']);
Route::post('new/v4/payout/checkstatus', [YESBANKController::class, 'checkStatus']);
 
//neokred
// Route::post('v1/genarteQR', [PayinController::class, 'genrateQR']);
// Route::post('v1/neokred/callback', [PayinController::class, 'callback']);
// Route::post('v1/checkstatus', [PayinController::class, 'checknewstatus']);





// Route::post('callback', [FlipzikController::class, 'callbackurltest']);
// //flipzik
// Route::post('v1/callback/flipzik/payout', [FlipzikController::class, 'callbackurl']);
// Route::post('v1/generatetoken/flipzik/payout', [FlipzikController::class, 'generatefliptoken']);
// Route::post('new/v1/payout/docashtransfer', [FlipzikController::class, 'transferflipfund']);
// Route::post('new/v4/payout/checkstatus', [FlipzikController::class, 'checkStatus']);


//waayupay
// Route::post('v1/generatetoken/paymonk/payout', [Waayupayout::class, 'generatetoken']);
// Route::post('v1/transferfund/paymonk/payout', [Waayupayout::class, 'doPayout']);
// Route::post('v1/checkpayoutstatus/paymonk/payout', [Waayupayout::class, 'checkstatus']);
// Route::post('v1/callback/waayupay/payout', [Waayupayout::class, 'paymonkcallback']);
Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
