<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Carbon;
use App\Models\User;
use App\Models\UserCharge;
use App\Models\UserIp;
use App\Models\UserTransaction;
use App\Models\WalletTopup;
use App\Models\PlatformCharge;
use App\Models\PayoutModel;
use App\Models\BankAccount;
use App\Models\RechargeModel;
use App\Models\RechargeCommission;
use Illuminate\Support\Facades\Session;
use Illuminate\Session\Store;

class Admin extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
 
    public function __construct()
    {
        
    }

    public function index()
    {   
        
        $usertransaction = UserTransaction::with('user')->orderBy('id','desc')->limit(5)->get();  
        $totalUsers = User::where('user_type',1)->count();
        $usersWithBalances = User::where('user_type',1)->sum('wallet');
        $today = Carbon::today();
        $status = ['SUCCESS','PENDING','PROCESSING'];
        $todayPayout = PayoutModel::whereDate('created_at', $today)->whereIn('status',$status)->sum('amount');
        $totalPayout = PayoutModel::whereIn('status',$status)->sum('amount');
        $todayTopUp = WalletTopup::whereDate('created_at', $today)->where('status',"APPROVED")->sum('amount');
        $totalTopUp = WalletTopup::where('status',"APPROVED")->sum('amount');
        return view('admin/dashboard',compact('usertransaction','totalUsers','usersWithBalances','todayPayout','totalPayout','todayTopUp','totalTopUp'));
    }

    public function changePassword(Request $request)
    {
        $data['content'] = "";
        if($_POST){
            $request->validate([
                'oldpassword' => 'required',
                'password' => 'required|min:8|confirmed',
                'password_confirmation' => 'required',
            ]);
             //$mpin = 131710;
            $user = Auth::user();

            if (Hash::check($request->oldpassword, $user->password)) {
                $user->update([
                    'password' => Hash::make($request->password)
                  
                      //'mpin' => Hash::make($mpin)
                ]);

                return redirect()->route('logout')->with('success', 'Password has been changed successfully.Please login');
            } else {
                return redirect()->back()->withErrors(['oldpassword' => 'Current password is incorrect.']);
            }
        }
        return view('admin/changepassword',compact('data'));
    }

    function viewProfile()
    {
        return view('admin/view-profile');
    }

    function manageUsers()
    {
        $user = User::orderBy('id','desc')->whereNotIn('user_type',[0,2,3,4])->paginate(500);
        return view('admin/manage-user',compact('user'));
    }

    function addUsers(Request $request)
    {
        if($_POST)
        {
            $request->validate([
                'name' => 'required',
                'mobile' => 'required|unique:users,mobile|regex:/^[6-9]\d{9}$/',
                'email' => 'required|email|unique:users,email',
                'password' => 'required',
                'pancard' => 'required|unique:users,pancard|regex:/^([A-Z]){5}([0-9]){4}([A-Z]){1}$/',
                'aadhaar' => 'required|unique:users,aadhaar_card|regex:/^\d{12}$/',
                'company' => 'required',
                'address' => 'required',
                'city' => 'required',
                'state' => 'required',
                'pincode' => 'required',
            ]);
            $user = Auth::user();
            $user_key = bin2hex(random_bytes(6));
            $user_token = bin2hex(random_bytes(20));
            User::create([
                'name' => $request['name'],
                'email' => $request['email'],
                'mobile' => $request['mobile'],
                'password' => Hash::make($request['password']),
                'aadhaar_card' => $request['aadhaar'],
                'pancard' => $request['pancard'],
                'address' => $request['address'],
                'city' => $request['city'],
                'state' => $request['state'],
                'pincode' => $request['pincode'],
                'company_name'=>$request['company'],
                'user_key'=>$user_key,
                'user_token'=>$user_token,
                'status' => 1,
                'api_status' => 1,
                'user_type' =>1,
                'agent_id'=>$request['agent'],
                'created_by' => $user->id,            
            ]);
            
            return redirect()->route('add-user')->with('success','User has been created successfully.');
        }
        $agent = User::orderBy('id','desc')->whereNotIn('user_type',[0,1,2,4])->get();
        return view('admin/add-user',compact('agent'));
    }

    function manageStaff()
    {
        $user = User::orderBy('id','desc')->whereNotIn('user_type',[0,1,3,4])->paginate(1000);
        return view('admin/manage-staff',compact('user'));
    }

    function manageAgent()
    {
        $user = User::orderBy('id','desc')->where('user_type',3)->paginate(1000);
        return view('admin/manage-agent',compact('user'));
    }    

    function addStaff(Request $request)
    {
        if($_POST)
        {
            $request->validate([
                'name' => 'required',
                'mobile' => 'required|unique:users,mobile|regex:/^[6-9]\d{9}$/',
                'email' => 'required|email|unique:users,email',
                'password' => 'required',
                'pancard' => 'required|unique:users,pancard|regex:/^([A-Z]){5}([0-9]){4}([A-Z]){1}$/',
                'aadhaar' => 'required|unique:users,aadhaar_card|regex:/^\d{12}$/',
                'company' => 'required',
                'address' => 'required',
                'city' => 'required',
                'state' => 'required',
                'pincode' => 'required',
            ]);
            $user = Auth::user();
            $user_key = "";
            $user_token = "";
            User::create([
                'name' => $request['name'],
                'email' => $request['email'],
                'mobile' => $request['mobile'],
                'password' => Hash::make($request['password']),
                'aadhaar_card' => $request['aadhaar'],
                'pancard' => $request['pancard'],
                'address' => $request['address'],
                'city' => $request['city'],
                'state' => $request['state'],
                'pincode' => $request['pincode'],
                'company_name'=>$request['company'],
                'user_key'=>$user_key,
                'user_token'=>$user_token,
                'status' => 1,
                'api_status' => 0,
                'user_type' =>2,
                'created_by' => $user->id,            
            ]);
    
            return redirect()->route('add-staff')->with('success','Staff has been created successfully.');
        }
        return view('admin/add-staff');
    }

    function addAgent(Request $request)
    {
        if($_POST)
        {
            $request->validate([
                'name' => 'required',
                'mobile' => 'required|unique:users,mobile|regex:/^[6-9]\d{9}$/',
                'email' => 'required|email|unique:users,email',
                'password' => 'required',
                'pancard' => 'required|unique:users,pancard|regex:/^([A-Z]){5}([0-9]){4}([A-Z]){1}$/',
                'aadhaar' => 'required|unique:users,aadhaar_card|regex:/^\d{12}$/',
                'company' => 'required',
                'address' => 'required',
                'city' => 'required',
                'state' => 'required',
                'pincode' => 'required',
            ]);
            $user = Auth::user();
            $user_key = "";
            $user_token = "";
            User::create([
                'name' => $request['name'],
                'email' => $request['email'],
                'mobile' => $request['mobile'],
                'password' => Hash::make($request['password']),
                'aadhaar_card' => $request['aadhaar'],
                'pancard' => $request['pancard'],
                'address' => $request['address'],
                'city' => $request['city'],
                'state' => $request['state'],
                'pincode' => $request['pincode'],
                'company_name'=>$request['company'],
                'user_key'=>$user_key,
                'user_token'=>$user_token,
                'status' => 1,
                'api_status' => 0,
                'user_type' =>3,
                'created_by' => $user->id,            
            ]);
    
            return redirect()->route('add-agent')->with('success','Agent has been created successfully.');
        }
        return view('admin/add-agent');
    }

    function manageUsersStatus(Request $request)
    {
        $id = $_POST['id'];
        $status = $_POST['status'];
        $type = $_POST['type'];
        $inputValue = $_POST['inputValue'];

        if($status == "DEACTIVE"){
            $statusnew = 0;
        }else{
            $statusnew = 1;
        }
        $user = User::findOrFail($id);
        if($type == "API"){
            $data = ['api_status'=>$statusnew];
        }else if($type == "status"){
            $data = ['status'=>$statusnew];
        }else if($type == "TECHNICAL"){
            $data = ['tecnical_issue'=>$statusnew];
        }else if($type == "BYBANK"){
            $data = ['bank_deactive'=>$statusnew];
        }else if($type == "flipzik"){
            $data = ['flipzik'=>$statusnew];
        }else if($type == "iserveu"){
            $data = ['iserveu'=>$statusnew];
        }else if($type == "IMPS"){
            $data = ['IMPS'=>$statusnew];
        }else if($type == "UPI"){
            $data = ['UPI'=>$statusnew];
        }
        
        
        // else if($type == "button_1"){
        //     $data = ['button_1'=>$statusnew];}
        //     else if($type == "button_2"){
        //     $data = ['button_2'=>$statusnew];}
        //     else if($type == "button_3"){
        //     $data = ['button_3'=>$statusnew];
            
            
            else if ($type == "button_1") {
        $data = ['button_1' => $statusnew, 'button_2' => 0, 'button_3' => 0];
    } elseif ($type == "button_2") {
        $data = ['button_1' => 0, 'button_2' => $statusnew, 'button_3' => 0];
    } elseif ($type == "button_3") {
        $data = ['button_1' => 0, 'button_2' => 0, 'button_3' => $statusnew];
            
            if (!empty($inputValue)) {
            $data['button3_value'] = $inputValue;  
        } else {
            $data['button3_value'] = null;  
        }
            }
        
            else{
            echo "No data has been updated.";
        die;
        }
        
       
    
        $user->update($data);
        echo "Status has been updated successfully";
        die;
    }

    public function manageUsersBank(Request $request)
    {
        $id = $_POST['id'];
        $user = BankAccount::findOrFail($id);
        $data = ['status'=>1];
        $user->update($data);
        echo "Bank Account has been approved successfully";
        die;
    }

    function updateUserCode(Request $request)
    {
        $id = $request['userid'];        
        $user = User::findOrFail($id);    
        $authcode = $request['authcode'];  
        $user->update([
            'authCode' => Hash::make($authcode)
        ]);
        return redirect()->route('manage-users')->with('success','Auth Code has been approved successfully.');
        die;
    }

    function resetUserPassword()
    {
        $id = $_POST['id'];        
        $user = User::findOrFail($id);    
        $password = "907648";   
        $user->update([
            'password' => Hash::make($password)
        ]);
        echo "password [".$password."] has been updated successfully";
        die;
    }

    function manageUserCharge($id,Request $request)
    {
        $userId = $id;
        $userCharge = UserCharge::where('userId',$userId)->get();
        $userIps = UserIp::where('userId',$userId)->get();
        $PlatformCharge = PlatformCharge::where('userId',$userId)->get();
        $BankAccount = BankAccount::where('userId',$userId)->get();
        $RechargeCommission = RechargeCommission::where('userId',$userId)->get();
        return view('admin/manage-user-charge',compact('userId','userCharge','userIps','PlatformCharge','BankAccount','RechargeCommission'));
    }

    function saveUserCharge(Request $request)
    {
        $user = Auth::user();
        UserCharge::create([
            'userId' => $request['userid'],
            'start_amount' => $request['start_amount'],
            'end_amount' => $request['end_amount'],
            'payout_charge' => $request['payout_charge'],
            'payin_charge' => $request['payin_charge'],
            'payin_charge_type' => $request['payin_charge_type'],
            'payout_charge_type' => $request['payout_charge_type'],
            'created_by' => $user->id,
        ]);

        //return redirect()->route('admin/manage-user-charge/'.$request['userid'])->with('success','User charge has been added successfully.');
        return redirect()->back()->with('success', 'User charge has been added successfully');
    }

    function saveUserCommission(Request $request)
    {

        $numEntries = count($request->operator);
        for ($i = 0; $i < $numEntries; $i++) {
            RechargeCommission::create([
                'userId' => $request->userid,
                'operator' => $request->operator[$i],
                'opcode'=>$request->operatorcode[$i],
                'commission' => $request->comm[$i],
                'type' => $request->commtype[$i],
            ]);
        }

        return redirect()->back()->with('success', 'User commission has been added successfully');
    }

    function saveUserIP(Request $request)
    {
        $Authuser = Auth::user();
       
        $mpin = $request['mpin'];
        if (Hash::check($mpin, $Authuser->lpin)) {
            
        }else{
            
            return redirect()->back()->with('success', 'Invalid M-PIN. Please enter valid M-PIN');
            die;
        }
        $user = Auth::user();
        UserIp::create([
            'userId' => $request['userid'],
            'ipAddress' => $request['ipaddress'],            
            'created_by' => $user->id,
        ]);        
        return redirect()->back()->with('success', 'User Ip address has been added successfully');
    }

    function saveUserPlatformCharge(Request $request)
    {
        $user = Auth::user();
        PlatformCharge::create([
            'userId' => $request['userid'],
            'charge' => $request['platform_charge'], 
            'gst' => $request['gst'],            
            'created_by' => $user->id,
        ]);        
        return redirect()->back()->with('success', 'User platform charge has been added successfully');
    }

    function saveUserSetting(Request $request)
    {
        $id = $request['userid'];
        $lien = $request['lien'];
        $rolling_reserve = $request['rolling_reserve'];
        $payin_callback = $request['payin_callback'];
        $payout_callback = $request['payout_callback'];
        $user = User::findOrFail($id);
        $data = [
            'lien'=>$lien,
            'rolling_reserve'=>$rolling_reserve,
            'payin_callback'=>$payin_callback,
            'payout_callback'=>$payout_callback,
        ];
        $user->update($data);
        return redirect()->route('manage-users')->with('success','User setting has been updated successfully.');
    }

    function updateUserFund(Request $request)
    {
        $userid = $request['userid'];
        $fund_type = $request['fund_type'];
        $amount = $request['amount'];
        $remark = $request['remark'];
        $mpin = $request['mpin'];
        $ipAddress = $request->ip();
        $txn_id = rand(12312,99099).Carbon::now()->timestamp;
        $User = new User();
        $user = User::findOrFail($userid);
        $openBal = $user->wallet;

        $Authuser = Auth::user();
        if (Hash::check($mpin, $Authuser->lpin)) {

        }else{
            return redirect()->route('manage-users')->with('success','Invalid M-PIN. Please enter valid M-PIN');
            die;
        }

        if($fund_type == "CREDIT"){
            $closeBal = $openBal + $amount;
            // $user->wallet += $amount;
            // $user->save();
            $query = $User->addFund($userid,$amount);
            //$query = $User->addFund(1,$amount);
        }
        if($fund_type == "DEBIT"){
            if($openBal < $amount){
                return redirect()->route('manage-users')->with('success','Insufficient user fund.');
            }                
            $closeBal = $openBal - $amount;
           
            $query = $User->deductFund($userid,$amount);
            //$query = $User->deductFund(1,$amount);
        }

        // $user->update([
        //     'wallet' => $closeBal,
        // ]);
        
        if($fund_type == "DEBIT"){
            UserTransaction::create([
                'userId' => $userid,
                'txnId' => $txn_id,
                'orderId' => $txn_id,
                'type' => $fund_type,
                'operator' => $fund_type, 
                'openBalance' =>$openBal, 
                'amount' => $amount,
                'walletBalance' =>$closeBal, 
                'credit' =>0, 
                'debit' =>$amount,   
                'remark' => $remark,  
                'status'=>"SUCCESS", 
                'requestIp' => $ipAddress,          
                'created_by' => $user->id,
            ]); 
        }

        if($fund_type == "CREDIT"){
            UserTransaction::create([
                'userId' => $userid,
                'txnId' => $txn_id,
                'orderId' => $txn_id,
                'type' => $fund_type,
                'operator' => $fund_type, 
                'openBalance' =>$openBal, 
                'amount' => $amount,
                'walletBalance' =>$closeBal, 
                'credit' =>$amount, 
                'debit' =>0,   
                'remark' => $remark,  
                'status'=>"SUCCESS",  
                'requestIp' => $ipAddress,          
                'created_by' => $user->id,
            ]); 
        }
        return redirect()->route('manage-users')->with('success','User fund has been updated successfully.');
    }

    function walletReport()
    {  
        $usersData = User::orderBy('id','desc')->where('user_type',1)->get();
        return view('admin/walletreport', compact('usersData'));
    }

    function WalletTopup(Request $request)
    {
        if($_POST){
            $request->validate([
                'user' => 'required',
                'amount' => ['required', 'numeric', 'min:1'],
                'remark' => 'required',
                 
            ]); 
            
          
            $Authuser = Auth::user();

            $userid = $request['user'];
            $amount = $request['amount'];
            $remark = $request['remark'];
            
            WalletTopup::create([
                'userId' => $userid,
                'amount' => $amount,
                'requestedBy' => $Authuser->name,
                'requestedRemark' => $remark,  
                'status' => "PENDING",      
                'created_by' => $Authuser->id,
                'IpAddress' => $request->ip(),
            ]);

            return redirect()->route('/admin/wallet-topup-request')->with('success','Wallet topup has been submited successfully.');
        }
        $users = User::orderBy('id','desc')->whereNotIn('user_type',[0,2])->get();
        return view('admin/wallet-topup',compact('users'));
    }

    function WalletTopupRequest(Request $request)
    {
        if($_POST){                 
            $Authuser = Auth::user();

            $status = $request['status'];
            $utr = $request['utr'];
            $requestId = $request['requestId'];
            $remark = $request['remark'];
            $mpin = $request['mpin'];

            $getData = WalletTopup::findOrFail($requestId);

            $Authuser = Auth::user();
            if (Hash::check($mpin, $Authuser->lpin)) {

            }else{
                return redirect()->route('/admin/wallet-topup-request')->with('success','Invalid M-PIN. Please enter valid M-PIN');
                die;
            }

            if($status == "DENIED"){

                $data = [
                    'approvedBy'=>$Authuser->name,
                    'approvedRemark'=>$remark,
                    'status'=>$status,
                ];
                $getData->update($data);
                return redirect()->route('/admin/wallet-topup-request')->with('success','Wallet topup has been denied successfully.');
            }
            
            if($status == "APPROVED"){

                $checkutr = WalletTopup::where("utr",$utr)->get();
                
                if(count($checkutr) != 0){
                    return redirect()->route('/admin/wallet-topup-request')->with('success','this utr is already used please check.');
                }
                $userId = $getData->userId;
                $amount = $getData->amount;
                $openBal = $getData->wallet;
                $getCharge = PlatformCharge::where("userId",$userId)->first();
                $charge = $getCharge->charge;
                $gst = $getCharge->gst;
                if($charge == ""){
                    $charge = 2;
                }
                if($gst == ""){
                    $gst = 18;
                }
                $calCharge = $amount*$charge/100;
                $calGst = $calCharge*$gst/100;
                $totalCharge = $calCharge+$calGst;
                $totalAddAmount = $amount-$totalCharge;
                $data = [
                    'charge'=>$calCharge,
                    'gst'=>$calGst,
                    'totalAmount'=>$totalAddAmount,
                    'utr'=>$utr,
                    'approvedBy'=>$Authuser->name,
                    'approvedRemark'=>$remark,
                    'status'=>$status,
                ];
                $getData->update($data);

                $ipAddress = $request->ip();
                $txn_id = rand(12312,99099).Carbon::now()->timestamp;

                $user = User::findOrFail($userId);
                $openBal = $user->wallet;

                $closeBal = $openBal + $totalAddAmount;
                $UserInstance = new User();
                $UserInstance->addFund($userId,$totalAddAmount);

                $remark = "WALLET TOP UP BY AMOUNT ".$amount;
                UserTransaction::create([
                    'userId' => $userId,
                    'txnId' => $txn_id,
                    'orderId' => $txn_id,
                    'type' => "CREDIT",
                    'operator' => "WALLETTOPUP", 
                    'openBalance' =>$openBal,
                    'amount' => $totalAddAmount,
                    'walletBalance' =>$closeBal, 
                    'credit' =>$totalAddAmount, 
                    'debit' =>0,   
                    'remark' => $remark,
                    'status'=>"SUCCESS",    
                    'requestIp' => $ipAddress,          
                    'created_by' => $Authuser->id,
                ]); 
                return redirect()->route('/admin/wallet-topup-request')->with('success','Wallet topup has been approved successfully.');
            }
        }        
        $today = Carbon::today();
        $WalletTopup = new WalletTopup();        
        $walletTopup = $WalletTopup->getWalletData();       
        $users = User::orderBy('id','desc')->whereNotIn('user_type',[0,2])->get();
        return view('admin/wallet-topup-request',compact('walletTopup','users'));
    }

    public function walletReportData(Request $request)
    {
        $start = $request['start'];
        $length = $request['length'];
        $date = $request['date'];
        $search_arr = $request['search'];
        $search = $search_arr['value'];
        $userId = $request['user'];
        $modelInstance = new UserTransaction();
        // $start, $length, $date="",$search="",$userId=""
        $getData = $modelInstance->getWalletDataAjax($start, $length, $date, $search, $userId);
        $totalRecords = UserTransaction::count();//$getData->count(); 
        $Data = $getData->get();
        $response = [
            'draw' => $request['draw'],
            'recordsTotal' => $totalRecords,
            'recordsFiltered' => $totalRecords,
            'data' => $Data,
        ];
        return response()->json($response);
    }

    public function WalletTopupSearch(Request $request)
    {
        if($_POST){
            $user = $request['user'];
            $status = $request['status'];
            $date = $request['date'];
           

            $WalletTopup = new WalletTopup();        
            $walletTopup = $WalletTopup->getWalletDataSearch($user,$status,$date); 
            $users = User::orderBy('id','desc')->whereNotIn('user_type',[0,2])->get();
            return view('admin/wallet-topup-request',compact('walletTopup','users'));
        }
    }

    public function payoutReport()
    {
        return view('admin/payoutreport');
    }

    public function payoutReportData(Request $request)
    {
        $start = $request['start'];
        $length = $request['length'];
        //$date = $request['date'];
        $search_arr = $request['search'];
        $search = $search_arr['value'];
    
        
       $fromdate = $request->input('fromDate') 
                ? \Carbon\Carbon::parse($request->input('fromDate'))->startOfDay() 
                : null;
    $todate = $request->input('toDate') 
              ? \Carbon\Carbon::parse($request->input('toDate'))->endOfDay() 
              : null;
        $status = $request->input('statusdropdown');
    

    
        $modelInstance = new PayoutModel();
        // $getData = $modelInstance->getWalletDataAjax($start,$length,$date,$search);
        
         $getData = $modelInstance->getWalletDataAjaxview($start,$length,$search,$fromdate,$todate,$status);
        
        $totalRecords = PayoutModel::count();
        
        
         $counteddata = $modelInstance->getWalletDataAjaxviewcount($search,$fromdate,$todate,$status);

       $Data = $getData->get(); 
       

        $response = [
           'draw' => $request['draw'],
            'recordsTotal' => $totalRecords,
            'recordsFiltered' => $counteddata,
            'data' => $Data,
        ];
        return response()->json($response);
    }

    public function readCSVold(Request $request)
    {

        // Validate the uploaded file
        $request->validate([
            'csv_file' => 'required|mimes:csv,txt',
        ]);

        // Get the uploaded CSV file
        $csvFile = $request->file('csv_file');

        $data = [];

        // Open the CSV file for reading
        if (($handle = fopen($csvFile->path(), 'r')) !== false) {
            while (($row = fgetcsv($handle)) !== false) {
                if($row[0] != "transfer_mode"){
                    if($row[0] != ""){                    
                    $data[] = $row;                    
                    }
                }                
            }
            fclose($handle);
        }
        
      
         $dataSend = [];
        foreach($data as $row){
           
            $dataSend['merchant_order_id'] = "PAY".rand(12312,99099).Carbon::now()->timestamp;
            $dataSend['amount'] = $row[1];
            $dataSend['name'] = $row[2];
            $dataSend['mobile_number'] = $row[3];
            $dataSend['account_number'] = $row[4];
            $dataSend['ifsc'] = $row[5];
            $dataSend['bank_name'] = $row[6];  
            $dataSend['address']= $row[7];
           
         
            
            $send = json_encode($dataSend);
            // $this->hitpayout($send);  
          
            $this->hitpayout($send, $request);
        }
    }
    
public function readCSV(Request $request)
{
    // Validate the uploaded file
    $request->validate([
        'csv_file' => 'required|mimes:csv,txt',
    ]);

    // Get the uploaded CSV file
    $csvFile = $request->file('csv_file');

    $data = [];

    // Open the CSV file for reading
    if (($handle = fopen($csvFile->path(), 'r')) !== false) {
        $headersSkipped = false; // Flag to skip the header row
        while (($row = fgetcsv($handle)) !== false) {
            if (!$headersSkipped) {
                $headersSkipped = true;
                continue; // Skip the header row
            }
            $data[] = $row;
        }
        fclose($handle);
    }

    // Loop through each row in $data
    foreach ($data as $row) {
        $dataSend = [
            'merchant_order_id' => "PAY" . rand(12312, 99099) . Carbon::now()->timestamp,
            'amount' => $row[1],
            'name' => $row[2],
            'mobile_number' => $row[3],
            'account_number' => $row[4],
            'ifsc' => $row[5],
            'bank_name' => $row[6],
            'address' => $row[7],
        ];

       
        $send = json_encode($dataSend);

        $this->hitpayout($send);
    }
}


   
    
    function hitpayout($data){
      
        $curl = curl_init();
    
        curl_setopt_array($curl, [
            // CURLOPT_URL => "https://dashboard.seospay.in/api/v2/doPayout",
             CURLOPT_URL => "https://api.seospay.in/api/v1/transferfund/flipzik/payout",
            CURLOPT_RETURNTRANSFER => false,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $data,
           CURLOPT_HTTPHEADER => [
            'Content-Type: application/json',
            'AuthKey: 99106c21fbe5',
            'AuthToken: f1ebf003789c44677ad68cd4debaaa5d2d8dc2a9',
            'AuthCode: 12345',
           
        ],
        ]);
    
        $response = curl_exec($curl);
        //echo $data;
        // Check for cURL errors
        if (curl_errno($curl)) {
            $error = curl_error($curl);
            echo "cURL Error: " . $error;
        }
    
        // Close cURL session
        curl_close($curl);
    
        // Return the response
        echo $response;

}
    // By Deepak
    // public function bulkPayout(){
    //     return view('admin/bulkpayout');
    // }
    public function moneyTransfer(){
        return view('admin/moneyTransfer');
    }
    public function aepsReport(){
        return view('admin/aepsReport');
    }
    public function recharge(){
        return view('admin/recharge');
    }

    public function WalletTopupReport()
    {
        $today = Carbon::today();
        $walletTopup = WalletTopup::whereDate('created_at', $today)->where('status',"APPROVED")->orderBy('id','desc')->get();
        $todayTopUp = WalletTopup::whereDate('created_at', $today)->where('status',"APPROVED")->sum('amount');
        $totalTopUp = WalletTopup::where('status',"APPROVED")->sum('amount');
        return view('admin/wallet-topup-report',compact('walletTopup','totalTopUp','todayTopUp'));
    }

    public function datasavepre(Request $request)
    {

        $csvFile = $request->file('csv_file');
        $data = [];

        if (($handle = fopen($csvFile->path(), 'r')) !== false) {
            while (($row = fgetcsv($handle)) !== false) {
                if($row[0] != "transfer_mode"){
                    if($row[0] != ""){                    
                    $data[] = $row;                    
                    }
                }                
            }
            fclose($handle);
        }
        $dataSend = [];
        foreach($data as $row){
            $dataSend['id'] = $row[0];
            $dataSend['userId'] = $row[1];
            $dataSend['txnId'] = $row[2];
            $dataSend['orderId'] = $row[3];
            $dataSend['type'] = $row[4];
            $dataSend['operator'] = $row[5];
            $dataSend['openBalance'] = $row[6];
            $dataSend['amount'] = $row[7];
            $dataSend['walletBalance'] = $row[8];    
            $dataSend['credit'] = $row[9];  
            $dataSend['debit'] = $row[10];  
            $dataSend['remark'] = $row[11];  
            $dataSend['requestIp'] = $row[12];  
            $dataSend['api'] = $row[13];  
            $dataSend['refundId'] = $row[14];  
            $dataSend['status'] = $row[15];  
            $dataSend['created_by'] = $row[16];  
            $dataSend['updated_by'] = 1;  
            $dataSend['created_at'] = $row[18];  
            $dataSend['updated_at'] = $row[19];
            
            //$send = json_encode($dataSend);
            //$this->hitpayout($send);
            //print_r($dataSend);die;
            UserTransaction::create($dataSend);
            
        }
    }


    public function walletReportDataExport(Request $request)
    {
        $selectedColumns = ['user_transactions.userId','user_transactions.orderId','user_transactions.type','user_transactions.openBalance','payout_transactions.IpAddress','user_transactions.amount','user_transactions.walletBalance','user_transactions.remark','user_transactions.created_at','user_transactions.status','users.name'];
        $query = UserTransaction::select($selectedColumns)->join('users', 'user_transactions.userId', '=', 'users.id')->leftjoin('payout_transactions' ,'user_transactions.txnId','=','payout_transactions.txnId' );
        if($request->date!=null) {
            $query->whereDate('user_transactions.created_at', $request->date);
        }
        if($request->user!=null) {
            $query->where('user_transactions.userId', $request->user);
        }
        $data = $query->get();
        
        if($request->actionType=="export") {
            $filename = 'wallet_txn_'. $request->date .'.csv';
            $file = fopen($filename,"w");
            // Header row - Remove this code if you don't want a header row in the export file.
            $header = array("Type","Date","OrderId","User", "Descrption", "Open Balance","Amount","Wallet balance","Status","IP"); 
            fputcsv($file,$header); 
    
            foreach($data as $row){
                $type = $row->type;
                $created_at = $row->created_at;
                $orderId = $row->orderId;
                $name = $row->name;   
                $remark = $row->remark;
                $openBalance = $row->openBalance;
                $amount = $row->amount;
                $walletBalance = $row->walletBalance;   
                $status = $row->status;
                $ip = $row->IpAddress;
                // Write to file 
                $users_arr = array($type, $created_at,$orderId, $name,$remark, $openBalance, $amount,$walletBalance,$status,$ip);
                fputcsv($file,$users_arr); 
            }
    
            fclose($file);
            header("Content-Description: File Transfer");
            header("Content-Disposition: attachment; filename=$filename");
            header("Content-Type: application/csv; ");
            readfile($filename);
    
            // deleting file
            unlink($filename);
            exit(); 
            
        }
    }

    public function payoutReportDataExport(Request $request)
    {
        $user = Auth::user();
        $userId = $user->id;
      $fromdate = \Carbon\Carbon::parse($request->input('fromDate'))->startOfDay();
$todate = \Carbon\Carbon::parse($request->input('toDate'))->endOfDay();
          $status = $request['statusdropdown'];
        
        
        $selectedColumns = ['payout_transactions.orderId','payout_transactions.txnId','payout_transactions.IpAddress','payout_transactions.amount','payout_transactions.charge','payout_transactions.gst','payout_transactions.totalAmount','payout_transactions.beneName','payout_transactions.beneAccount','payout_transactions.beneIfsc','payout_transactions.utr','payout_transactions.status','payout_transactions.created_at','payout_transactions.updated_at','users.name'];
        
        // $query = PayoutModel::whereDate('payout_transactions.created_at', $date)->select($selectedColumns)->join('users', 'payout_transactions.userId', '=', 'users.id');
        // $data = $query->get();
        
         $query = PayoutModel::select($selectedColumns)
        ->join('users', 'payout_transactions.userId', '=', 'users.id')
        ->whereBetween('payout_transactions.created_at', [$fromdate, $todate])
        ->when($status, function ($query, $status) {
            return $query->where('payout_transactions.status', $status);
        })
        ->orderBy('payout_transactions.id', 'desc');
        
        // $d = $query->toSql();
        // print_r($d);
        // $p=$query->getBindings();
        // print_r($p);

    // Fetch data
    $data = $query->get();
    


  $currentDate = now()->format('Y-m-d');
        $filename = 'Payout_txn_'.$currentDate.'.csv';
        $file = fopen($filename,"w");

        // Header row - Remove this code if you don't want a header row in the export file.
        $header = array("OrderId","User","Transaction Id","UTR","Name", "Account Number", "Ifsc","Amount","Charge","Gst","Net Amount","Status","Date","Remark","IP"); 				
        fputcsv($file,$header); 

        foreach($data as $row){
            $OrderId = $row->orderId;
            $name = $row->name;
            $txnid = $row->txnId;
            $utr = $row->utr;   
            $beneName = $row->beneName;
            $beneAccount = $row->beneAccount;
            $beneIfsc = $row->beneIfsc;
            $amount = $row->amount;   
            $charge = $row->charge;
            $gst = $row->gst;   
            $totalAmount = $row->totalAmount;
            $status = $row->status;   
            $created_at = $row->created_at;
            $updated_at = $row->updated_at;
            $remark = '';
            $ip = $row->IpAddress;

   
    if ($status === 'SUCCESS' || $status === 'FAILED') {
        // Calculate the time difference between created_at and updated_at
        $timeDifference = strtotime($updated_at) - strtotime($created_at);
        
    //   dd($created_at." ".$updated_at." ".$timeDifference);
      
       
        
        // If time difference is less than or equal to 1 minute
        if ($timeDifference <= 60) {
            $remark = 'instant';
        } else {
            $remark = 'delay';
        }
    }

            // Write to file 
            $users_arr = array($OrderId,$name,$txnid,$utr, $beneName, $beneAccount, $beneIfsc,$amount,$charge,$gst,$totalAmount,$status,$created_at,$remark,$ip);
            fputcsv($file,$users_arr); 
        }

        fclose($file);
        header("Content-Description: File Transfer");
        header("Content-Disposition: attachment; filename=$filename");
        header("Content-Type: application/csv; ");

        readfile($filename);

        // deleting file
        unlink($filename);
        exit();     
    }

    public function topupReportDataExport(Request $request)
    {
        $user = Auth::user();
        $userId = $user->id;
        $date = $request['txndate'];
        $submit = $request['submit'];
        if($submit == "EXPORT"){

            $selectedColumns = ['wallet_topups.amount','wallet_topups.charge','wallet_topups.gst','wallet_topups.totalAmount','wallet_topups.IpAddress','wallet_topups.utr','wallet_topups.created_at','users.name'];
            $query = WalletTopup::whereDate('wallet_topups.created_at', $date)->select($selectedColumns)->join('users', 'wallet_topups.userId', '=', 'users.id');
            $data = $query->get();

            $filename = 'wallet_topup_txn_'.$date.'.csv';
            $file = fopen($filename,"w");

            // Header row - Remove this code if you don't want a header row in the export file.
            $header = array("Date","User","Amount","Charge","Gst","Net Amount", "Utr","Status", "IP"); 									
            fputcsv($file,$header); 

            foreach($data as $row){
                $created_at = $row->created_at;
                $name = $row->name;
                $amount = $row->amount;   
                $charge = $row->charge;
                $gst = $row->gst;   
                $totalAmount = $row->totalAmount;
                $utr = $row->utr;   
                $status = "SUCCESS";
                $ip = $row->IpAddress;

                // Write to file 
                $users_arr = array($created_at,$name,$amount,$charge,$gst,$totalAmount,$utr,$status,$ip);
                fputcsv($file,$users_arr); 
            }

            fclose($file);
            header("Content-Description: File Transfer");
            header("Content-Disposition: attachment; filename=$filename");
            header("Content-Type: application/csv; ");

            readfile($filename);

            // deleting file
            unlink($filename);
            exit();     
        }

        if($submit == "VIEW")
        {
            $today = Carbon::today();
            $walletTopup = WalletTopup::whereDate('created_at', $date)->where('status',"APPROVED")->orderBy('id','desc')->get();
            $todayTopUp = WalletTopup::whereDate('created_at', $date)->where('status',"APPROVED")->sum('amount');
            $totalTopUp = WalletTopup::where('status',"APPROVED")->sum('amount');
            return view('admin/wallet-topup-report',compact('walletTopup','totalTopUp','todayTopUp'));
        }
    }

    public function getDailyData()
    {
        $PayoutModel = new PayoutModel();
        $data = $PayoutModel->getDailyTxn();
        echo "<PRE>";
        print_r($data);
    }

    public function getPayoutData()
    {
        $today = "2023-12-30 00:00:00";

        $PayoutData = PayoutModel::whereDate('created_at', $today)->where('status',"PENDING")->limit(200)->orderBy('id', 'ASC')->get();
        foreach($PayoutData as $data)
        {
            $sendData['referenceNumber'] = $data->orderId;
            $send = json_encode($sendData);
            $this->hitCheckStatus($send);
        }
    }

    public function checkPendingStatus(Request $request)
    {
        if($_POST)
        {
            $today = $request['txndate'];
            $PayoutData = PayoutModel::whereDate('created_at', $today)->where('status',"PENDING")->limit(100)->orderBy('id', 'ASC')->get();
            foreach($PayoutData as $data)
            {
                $sendData['referenceNumber'] = $data->orderId;
                $send = json_encode($sendData);
                $this->hitCheckStatus($send);
            }
        }

        return view('admin/checkstatus');
    }

    function hitCheckStatus($data){

        $header = array(
            'Content-Type:application/json',
            'Authorization: cabe1a7fa1ebb5c658be9f5fac45d0bc08193829'
        );
    
        $curl = curl_init();
    
        curl_setopt_array($curl, [
            CURLOPT_URL => "https://api.seospay.tech/api/new/checkstatus",
            CURLOPT_RETURNTRANSFER => false,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $data,
            CURLOPT_HTTPHEADER => $header
        ]);
    
        $response = curl_exec($curl);
        if (curl_errno($curl)) {
            $error = curl_error($curl);
            echo "cURL Error: " . $error;
        }
        // Close cURL session
        curl_close($curl);
        // Return the response
        echo $response;
    }
    
     function updatestatus(Request $request){
         
         $send = [
        'referenceNumber' => $request->input('orderId'),
    ];
         
          $send1 = json_encode($send);

        $header = array(
            'Content-Type:application/json',
            'Authorization: cabe1a7fa1ebb5c658be9f5fac45d0bc08193829'
        );
    
        $curl = curl_init();
    
        curl_setopt_array($curl, [
            CURLOPT_URL => "https://api.seospay.tech/api/new/checkstatus",
            CURLOPT_RETURNTRANSFER => false,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $send1,
            CURLOPT_HTTPHEADER => $header
        ]);
    
        $response = curl_exec($curl);
        echo $response;
        if (curl_errno($curl)) {
            $error = curl_error($curl);
            echo "cURL Error: " . $error;
        }
       
        curl_close($curl);
        
        $decodedResponse = json_decode($response, true);

   
        return response()->json($decodedResponse);
   
}
    

    function manageStaffIp($id,Request $request)
    {
        $userid = $id;
        $userIps = UserIp::where('userId',$userid)->get();
        return view('admin/manage-staff-ip',compact('userid','userIps'));
    }

   public function addStaffIp(Request $request)
   {
        $user = Auth::user();
        UserIp::create([
            'userId' => $request['userid'],
            'ipAddress' => $request['ipaddress'],            
            'created_by' => $user->id,
        ]);        
        return redirect()->back()->with('success', 'User Ip address has been added successfully');
   }
   
     public function refund(Request $request)
    {
        if($_POST)
        {
            $today = $request['txndate'];
            $PayoutData = PayoutModel::whereDate('created_at', $today)->where('status',"FAILED")->limit(100)->orderBy('id', 'ASC')->get();
            foreach($PayoutData as $data)
            {
                $sendData['referenceNumber'] = $data->orderId;
                $send = json_encode($sendData);
                //echo $send;
                
                $this->hitrefund($send);
            }
        }

        return view('admin/checkstatus');
    }

    function hitrefund($data){

        $header = array(
            'Content-Type:application/json',
            'Authorization:f1ebf003789c44677ad68cd4debaaa5d2d8dc2a9'
        );
    
        $curl = curl_init();
    
        curl_setopt_array($curl, [
            CURLOPT_URL => "https://api.seospay.tech/api/v7/payoutrefund",
            CURLOPT_RETURNTRANSFER => false,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $data,
            CURLOPT_HTTPHEADER => $header
        ]);
    
        $response = curl_exec($curl);
        if (curl_errno($curl)) {
            $error = curl_error($curl);
            echo "cURL Error: " . $error;
        }
        // Close cURL session
        curl_close($curl);
        // Return the response
        echo $response;
    }


}
