<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('password');
            $table->double('wallet', 14, 4)->default(0);
            $table->double('lien', 14, 4)->default(0);
            $table->double('rolling_reserve', 14, 4)->default(0);
            $table->string('user_key')->nullable();
            $table->string('user_token')->nullable();
            $table->string('mobile')->unique();
            $table->string('email')->unique();
            $table->string('company_name')->nullable();
            $table->string('aadhaar_card')->unique();
            $table->string('pancard')->unique();
            $table->string('address')->nullable();
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->string('pincode')->nullable();
            $table->tinyInteger('status')->default(0); /* status: 1=>ACTIVE, 0=>DEACTIVE*/
            $table->tinyInteger('api_status')->default(0); /* api_status:  1=>ACTIVE, 0=>DEACTIVE */
            $table->tinyInteger('user_type')->default(0); /* user_type: 1=>Admine, 2=>Api User, 3=>Staff */
            $table->integer('created_by')->payin_callback();
            $table->integer('updated_by')->payout_callback();
            $table->rememberToken()->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
};
