<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_transactions', function (Blueprint $table) {
            $table->id();
            $table->integer('userId');
            $table->string('txnId')->nullable();
            $table->string('orderId')->nullable();
            $table->string('type')->nullable();
            $table->double('amount', 14, 4)->default(0);
            $table->double('walletBalance', 14, 4)->default(0);
            $table->string('remark')->nullable();
            $table->string('requestIp')->nullable();
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_transactions');
    }
};
