<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('wallet_topups', function (Blueprint $table) {
            $table->id();
            $table->integer('userId');
            $table->double('amount', 14, 4)->default(0);
            $table->string('utr')->nullable();
            $table->string('requestedBy')->nullable();    
            $table->string('requestedRemark')->nullable();
            $table->string('approvedBy')->nullable();    
            $table->string('approvedRemark')->nullable();  
            $table->string('status')->nullable();      
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('wallet_topups');
    }
};
