@include('admin/header')

<div class="page-container">

    <!-- Content Wrapper START -->

    <div class="main-content">

        <div class="page-header">

            <h2 class="header-title">Users</h2>

            <div class="header-sub-title">

                <nav class="breadcrumb breadcrumb-dash">

                    <a href="{{url('/admin/dashboard')}}" class="breadcrumb-item"><i class="anticon anticon-home m-r-5"></i>Home</a>                    

                    <span class="breadcrumb-item active">Users</span>

                </nav>

            </div>

        </div>

        <div class="card">

            <div class="card-body">

                @if(session('success'))

                    <div class="alert alert-success mb-1 mt-1">

                        {{ session('success') }}

                    </div>

                @endif

                <div class="row">

                    <div class="col-md-12 col-lg-12">                        

                        <div class="d-flex justify-content-between align-items-center">

                            <h5>Users</h5>

                            <div>

                                <a href="{{url('/admin/add-user')}}" class="btn btn-sm btn-primary">Add User</a>

                            </div>

                        </div>

                            <div class="m-t-30">

                                <div class="table-responsive">

                                    <table class="table table-hover table-bordered">

                                        <thead>

                                            <tr>

                                                <th>Name</th>

                                                <th>Wallet Bal</th>

                                                <th>Mobile</th>

                                                <th>Email</th>

                                                <th>Status</th>

                                                <th>Api Status</th>
                                                <th>Technical issue</th>
                                                <th>Deactivated by Bank</th>
                                                <th>IserveU</th>
                                                <th>Flipzik</th>
                                                <th>IMPS/NEFT</th>
                                                <th>UPI</th>
                                                  <th>B2BF</th>
                                                    <th>3S1F</th>
                                                      <th>button_3</th>
                                                <th>Action</th>

                                            </tr>

                                        </thead>

                                        <tbody>

                                            @foreach ($user as $rows)

                                                <tr>

                                                    <td>{{$rows->name}}</td>

                                                    <td>{{$rows->wallet}}</td>

                                                    <td>{{$rows->mobile}}</td>

                                                    <td>{{$rows->email}}</td>

                                                    <td>

                                                        @if($rows->status == 1)

                                                            <button class="btn btn-sm btn-success" onClick="changeStatus({{$rows->id}},'DEACTIVE','status')">ACTIVE</button>

                                                        @else

                                                            <button class="btn btn-sm btn-danger" onClick="changeStatus({{$rows->id}},'ACTIVE','status')">DEACTIVE</button>

                                                        @endif

                                                    </td>

                                                    <td>

                                                        @if($rows->api_status == 1)

                                                            <button class="btn btn-sm btn-success"  onClick="changeStatus({{$rows->id}},'DEACTIVE','API')">ACTIVE</button>

                                                        @else

                                                            <button class="btn btn-sm btn-danger"  onClick="changeStatus({{$rows->id}},'ACTIVE','API')">DEACTIVE</button>

                                                        @endif

                                                    </td>

                                                    <td>

                                                    @if($rows->tecnical_issue == 0)

                                                        <button class="btn btn-sm btn-danger"  onClick="changeStatus({{$rows->id}},'ACTIVE','TECHNICAL')">DEACTIVE</button>

                                                    @else

                                                        <button class="btn btn-sm btn-success"  onClick="changeStatus({{$rows->id}},'DEACTIVE','TECHNICAL')">ACTIVE</button>

                                                    @endif

                                                    </td>
                                                    <td>
                                                        @if($rows->bank_deactive == 0)
                                                            <button class="btn btn-sm btn-danger"  onClick="changeStatus({{$rows->id}},'ACTIVE','BYBANK')">DEACTIVE</button>
                                                        @else
                                                            <button class="btn btn-sm btn-success"  onClick="changeStatus({{$rows->id}},'DEACTIVE','BYBANK')">ACTIVE</button>
                                                        @endif
                                                    </td>

                                                    <td>
                                                        @if($rows->iserveu == 0)
                                                            <button class="btn btn-sm btn-danger"  onClick="changeStatus({{$rows->id}},'ACTIVE','iserveu')">DEACTIVE</button>
                                                        @else
                                                            <button class="btn btn-sm btn-success"  onClick="changeStatus({{$rows->id}},'DEACTIVE','iserveu')">ACTIVE</button>
                                                        @endif
                                                    </td>

                                                    <td>
                                                        @if($rows->flipzik == 0)
                                                            <button class="btn btn-sm btn-danger"  onClick="changeStatus({{$rows->id}},'ACTIVE','flipzik')">DEACTIVE</button>
                                                        @else
                                                            <button class="btn btn-sm btn-success"  onClick="changeStatus({{$rows->id}},'DEACTIVE','flipzik')">ACTIVE</button>
                                                        @endif
                                                    </td>

                                                    <td>
                                                        @if($rows->IMPS == 0)
                                                            <button class="btn btn-sm btn-danger"  onClick="changeStatus({{$rows->id}},'ACTIVE','IMPS')">DEACTIVE</button>
                                                        @else
                                                            <button class="btn btn-sm btn-success"  onClick="changeStatus({{$rows->id}},'DEACTIVE','IMPS')">ACTIVE</button>
                                                        @endif
                                                    </td>

                                                    <td>
                                                        @if($rows->UPI == 0)
                                                            <button class="btn btn-sm btn-danger"  onClick="changeStatus({{$rows->id}},'ACTIVE','UPI')">DEACTIVE</button>
                                                        @else
                                                            <button class="btn btn-sm btn-success"  onClick="changeStatus({{$rows->id}},'DEACTIVE','UPI')">ACTIVE</button>
                                                        @endif
                                                    </td>
                                                    
                                                    <td>
                                                    @if($rows->button_1 == 0)
                                                            <button class="btn btn-sm btn-danger"  onClick="changeStatus({{$rows->id}},'ACTIVE','button_1')">DEACTIVE</button>
                                                        @else
                                                            <button class="btn btn-sm btn-success"  onClick="changeStatus({{$rows->id}},'DEACTIVE','button_1')">ACTIVE</button>
                                                        @endif
                                                    </td>

                                          <td>
                                                    @if($rows->button_2 == 0)
                                                            <button class="btn btn-sm btn-danger"  onClick="changeStatus({{$rows->id}},'ACTIVE','button_2')">DEACTIVE</button>
                                                        @else
                                                            <button class="btn btn-sm btn-success"  onClick="changeStatus({{$rows->id}},'DEACTIVE','button_2')">ACTIVE</button>
                                                        @endif
                                                    </td>
                                                    
                                                     <td>
                                                    @if($rows->button_3 == 0)

                                    
<button class="btn btn-sm btn-danger" onClick="changeStatusIfValid({{ $rows->id }}, 'ACTIVE', 'button_3')">DEACTIVE</button><br><br>

 <input type="text" id="inputValue_{{ $rows->id }}" placeholder="Enter value" required />
    
                                                        @else
                                                        
                                     

                                                             <button class="btn btn-sm btn-success"  onClick="changeStatus({{$rows->id}},'DEACTIVE','button_3')">ACTIVE</button><br><br>
                                                             
                                                              <input type="text" value="{{ $rows->button3_value }}" readonly />
                                                        @endif
                                                    </td>

                                                    <td>                                                    

                                                        <a class="btn btn-icon btn-success" href="{{url('admin/manage-user-charge/'.$rows->id)}}">

                                                            <i class="anticon anticon-plus"></i>

                                                        </a>

                                                        <button class="btn btn-icon btn-primary" data-toggle="modal" data-target="#setting_{{$rows->id}}">

                                                            <i class="anticon anticon-setting"></i>

                                                        </button>

                                                        <button class="btn btn-icon btn-warning" data-toggle="modal" data-target="#fund_{{$rows->id}}">
                                                            <i class="anticon anticon-money-collect"></i>
                                                        </button>

                                                        <button class="btn btn-icon btn-info" data-toggle="modal" data-target="#AuthCode_{{$rows->id}}">
                                                            <i class="anticon anticon-deployment-unit"></i>
                                                        </button>
                                                        
                                                    </td>

                                                </tr>



                                                <!-- model Stting-->

                                                <div class="modal fade" id="setting_{{$rows->id}}">

                                                    <div class="modal-dialog modal-dialog-scrollable">

                                                        <div class="modal-content">

                                                            <div class="modal-header">

                                                                <h5 class="modal-title" id="exampleModalScrollableTitle">Setting</h5>

                                                                <button type="button" class="close" data-dismiss="modal">

                                                                    <i class="anticon anticon-close"></i>

                                                                </button>

                                                            </div>

                                                                <div class="modal-body">
                                                                <div class="form-group">
                                                                    <label for="inputAddress">User Key</label>
                                                                    <input type="text" class="form-control" name="" placeholder="Payout Callback" value="{{$rows->user_key}}" readonly>
                                                                </div>

                                                                <div class="form-group">
                                                                    <label for="inputAddress">User Token</label>
                                                                    <input type="text" class="form-control" name="" placeholder="Payout Callback" value="{{$rows->user_token}}" readonly>
                                                                </div>

                                                                <form action="{{url('admin/save-user-setting')}}" method="POST">

                                                                @csrf

                                                                <div class="form-group">

                                                                    <label for="inputAddress">Lien Amount</label>

                                                                    <input type="text" class="form-control" name="lien" placeholder="Lien Amount" value="{{$rows->lien}}">

                                                                </div>

                                                                <div class="form-group">

                                                                    <label for="inputAddress">Rolling Reserve Amount</label>

                                                                    <input type="text" class="form-control" name="rolling_reserve" placeholder="Rolling Reserve Amount" value="{{$rows->rolling_reserve}}">

                                                                </div>

                                                                <div class="form-group">

                                                                    <label for="inputAddress">Payin Callback</label>

                                                                    <input type="text" class="form-control" name="payin_callback" placeholder="Payin Callback" value="{{$rows->payin_callback}}">

                                                                </div>

                                                                <div class="form-group">

                                                                    <label for="inputAddress">Payout Callback</label>

                                                                    <input type="text" class="form-control" name="payout_callback" placeholder="Payout Callback" value="{{$rows->payout_callback}}">

                                                                </div>

                                                                <input type="hidden" name="userid" value="{{$rows->id}}"/>

                                                                    

                                                                </div>

                                                                <div class="modal-footer">

                                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>

                                                                    <button type="submit" class="btn btn-primary">Save</button>

                                                                </div>

                                                            </form>

                                                        </div>

                                                    </div>

                                                </div>

                                                <!-- model Fund-->

                                                <div class="modal fade" id="fund_{{$rows->id}}">

                                                    <div class="modal-dialog modal-dialog-scrollable">

                                                        <div class="modal-content">

                                                            <div class="modal-header">

                                                                <h5 class="modal-title" id="exampleModalScrollableTitle">User Fund</h5>

                                                                <button type="button" class="close" data-dismiss="modal">

                                                                    <i class="anticon anticon-close"></i>

                                                                </button>

                                                            </div>

                                                                <div class="modal-body">

                                                                <form action="{{url('admin/update-user-fund')}}" method="POST">

                                                                @csrf

                                                                <div class="form-group">

                                                                    <label for="inputAddress">Type</label>

                                                                    <select class="form-control" name="fund_type" required>

                                                                        <option value="CREDIT">CREDIT</option>

                                                                        <option value="DEBIT">DEBIT</option>

                                                                    </select>

                                                                </div>

                                                                <div class="form-group">
                                                                    <label for="inputAddress">Amount</label>
                                                                    <input type="text" class="form-control" name="amount" placeholder="Amount" required>
                                                                </div>

                                                                <div class="form-group">
                                                                    <label for="inputAddress">Remark</label>
                                                                    <input type="text" class="form-control" name="remark" placeholder="Remark" required>
                                                                </div> 
                                                                
                                                                <div class="form-group">
                                                                    <label for="inputAddress">MPIN</label>
                                                                    <input type="text" class="form-control" name="mpin" placeholder="M-PIN" required>
                                                                </div> 

                                                                <input type="hidden" name="userid" value="{{$rows->id}}"/>                                                                    

                                                                </div>

                                                                <div class="modal-footer">

                                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>

                                                                    <button type="submit" class="btn btn-primary">Update Fund</button>

                                                                </div>

                                                            </form>

                                                        </div>

                                                    </div>

                                                </div>

                                                <div class="modal fade" id="AuthCode_{{$rows->id}}">

                                                    <div class="modal-dialog modal-dialog-scrollable">

                                                        <div class="modal-content">

                                                            <div class="modal-header">

                                                                <h5 class="modal-title" id="exampleModalScrollableTitle">Set Code</h5>

                                                                <button type="button" class="close" data-dismiss="modal">

                                                                    <i class="anticon anticon-close"></i>

                                                                </button>

                                                            </div>

                                                                <div class="modal-body">

                                                                <form action="{{url('admin/update-user-authcode')}}" method="POST">

                                                                @csrf

                                                                

                                                                <div class="form-group">
                                                                    <label for="inputAddress">Auth Code</label>
                                                                    <input type="text" class="form-control" name="authcode" placeholder="Auth Code" required>
                                                                </div>

                                                                 

                                                                <input type="hidden" name="userid" value="{{$rows->id}}"/>                                                                    

                                                                </div>

                                                                <div class="modal-footer">

                                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>

                                                                    <button type="submit" class="btn btn-primary">Update</button>

                                                                </div>

                                                            </form>

                                                        </div>

                                                    </div>

                                                </div>
                                            @endforeach                                            

                                        </tbody>

                                    </table>

                                    {!! $user->links() !!}

                                </div>

                            </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>

<script>    

 function changeStatusIfValid(id, status, buttonId) {
        var inputValue = document.getElementById('inputValue_' + id).value;

      
        if (inputValue.trim() === '') {
            alert('Please enter a value before submitting.');
            return; 
        }

    
        changeStatus(id, status, buttonId);
    }

    function changeStatus(id,status,type){

        var csrfToken = $('meta[name="csrf-token"]').attr('content');

            var inputValue = $('#inputValue_' + id).val() || ''; 

        $.ajaxSetup({

            headers: {

                'X-CSRF-TOKEN': csrfToken

            }

        });

        var url = '{{url('/admin/update-users-status')}}';

        $.ajax({

            type: 'POST',

            url: url,

            data: {

                'id':id,

                'status':status,

                'type':type,
                
                'inputValue': inputValue 

            },

            success: function (response) {

               alert(response);

               location.reload();

            }

        });

            

    }



</script>

    

@include('admin/footer')