@include('admin/header')

            <!-- Page Container START -->

            <div class="page-container">

                <!-- Content Wrapper START -->

                <div class="main-content">

                    <div class="row">

                        <div class="col-md-12 col-lg-12">

                            <div class="card">

                                <div class="card-body">

                                    <div class="d-flex justify-content-between align-items-center">

                                        <h5>Wallet Transactions</h5>
                                        <form action="{{ url('/admin/wallet-report-export') }}" method="POST" encType="multipart/form-data" >
                                            @csrf
                                            <input type="date" class="form-control-sm" id="date" name="date" title="Data" style="width:180px">
                                            <!--<select class="form-control-sm" id="user" name="user" title="Users" style="width:180px">-->
                                            <!--    <option value="">--: Select :--</option>-->
                                            <!--    @if (!empty($usersData))-->
                                            <!--        @foreach ($usersData as $rows)-->
                                            <!--            <option value="{{$rows->id}}" {{ old('user') == $rows->id ? 'selected' : '' }}>{{$rows->name}}</option>-->
                                            <!--        @endForeach-->
                                            <!--    @endif-->
                                            <!--</select>-->
                                            <button type="button" class="btn btn-sm btn-primary" id="viewButton" name="actionType" title="Search">View</button>
                                            <button type="submit" class="btn btn-sm btn-info" name="actionType" value="export" title="Export">Export</button>
                                        </form>
                                    </div>

                                    <div class="m-t-30">

                                        <div class="table-responsive-md table-responsive-sm table-responsive">

                                            <table class="table table-hover table-bordered" id="datatable"> 

                                                <thead>
                                                    <tr>
                                                        <th>Type</th>
                                                        <th>Date</th>
                                                        <th>OrderId</th>
                                                        <th>User</th>                                                        
                                                        <th>Descrption</th>
                                                        <th>Open Balance</th>
                                                        <th>Amount</th>
                                                        <th>Wallet balance</th>
                                                        <th>status</th>
                                                        <th> IP</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                </tbody>
                                            </table>
                                        </div>
                                        {{-- {{$usertransaction->links()}} --}}
                                    </div>

                                </div>

                            </div>

                        </div>

                       

                    </div>

                </div>

                <!-- Content Wrapper END -->

                <!-- model -->          

                

        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>
        <link href="https://cdn.datatables.net/v/dt/dt-1.13.5/datatables.min.css" rel="stylesheet">
        <script src="https://cdn.datatables.net/v/dt/dt-1.13.5/datatables.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
        <script type="text/javascript">
            $(document).ready(function () {
                var url = "{{ route('/admin/wallet-report-data') }}";
                let dataTable = new DataTable('#datatable', {
                    ajax: {
                        url: url,
                        type: 'POST',
                        data: function(d) {
                            d.type = "wallet";
                            d.date = $('#date').val();
                            
                            console.warn(d.date);
                            
                            
                            d.user = $('#user').val();
                            d._token = '{{ csrf_token() }}';
                        }
                    },
                    processing: true,
                    serverSide: true,
                    ordering: false,
                    columns : [
                        { 
                            data: 'type',
                            render: function(data, type, row) {
                                if (data === 'CREDIT') {
                                    return ' <button class="btn btn-icon btn-success"><i class="anticon anticon-arrow-down"></i></button>';
                                } else if (data === 'DEBIT') {
                                    return ' <button class="btn btn-icon btn-danger"><i class="anticon anticon-arrow-up"></i></button>';
                                } else {
                                    return '';
                                }
                            }
                        },
                        { 
                            data: 'created_at',
                            render: function(data) {
                                // Convert to local timezone
                                let date = new Date(data);
                                return date.toLocaleString('en-IN', { timeZone: 'Asia/Kolkata', hour12: false });
                            }
                        },
                        { "data": "orderId" },
                        { "data": "name" },
                        { "data": "remark" },
                        { "data" : "openBalance"},
                        { "data": "amount" },                 
                        { "data": "walletBalance" },
                        { "data": "status" },   
                        { "data": "IpAddress" },  
        
                    ],
                });
        
                $('#viewButton').on('click', function() {
                    dataTable.ajax.reload(); // Redraw the table based on new filters
                });
            });
        
        
        
        </script>



@include('admin/footer')