@include('user/header')

<div class="page-container">
    <!-- Content Wrapper START -->
    <div class="main-content">
        <div class="page-header">
            <h2 class="header-title">DMT LITE</h2>
            <div class="header-sub-title">
                <nav class="breadcrumb breadcrumb-dash">
                    <a href="{{ url('/user/dashboard') }}" class="breadcrumb-item">
                        <i class="anticon anticon-home m-r-5"></i>Home
                    </a>
                    <span class="breadcrumb-item active">DMT LITE</span>
                </nav>
            </div>
        </div>

        <div class="card">
            <div class="card-body">
                <form action="{{ url('/user/dmtlite') }}" method="POST" enctype="multipart/form-data">
                    @csrf

                    <div class="form-row">
                        <!-- Header fields -->
                        <!-- <div class="col-md-4 mb-3">
                            <label for="AuthKey">Auth Key</label>
                            <input type="text" class="form-control" id="AuthKey" name="AuthKey" placeholder="Enter Auth Key" value="">
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="AuthToken">Auth Token</label>
                            <input type="text" class="form-control" id="AuthToken" name="AuthToken" placeholder="Enter Auth Token" value="">
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="AuthCode">Auth Code</label>
                            <input type="text" class="form-control" id="AuthCode" name="AuthCode" placeholder="Enter Auth Code" value="">
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="Token">Token</label>
                            <input type="text" class="form-control" id="token" name="token" placeholder="Enter Token" value="">
                        </div> -->

                        <!-- Form fields -->
                        <div class="col-md-4 mb-3">
                            <label for="name">Name</label>
                            <input type="text" class="form-control" id="name" name="name" placeholder="Enter Name" value="">
                            <div class="invalid-feedback" style="display: block!important;">
                                @error('name')
                                    {{ $message }}
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="accountNumber">Account Number</label>
                            <input type="text" class="form-control" id="accountNumber" name="accountNumber" placeholder="Enter Account Number" value="">
                            <div class="invalid-feedback" style="display: block!important;">
                                @error('accountNumber')
                                    {{ $message }}
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="mobileNumber">Mobile Number</label>
                            <input type="text" class="form-control" id="mobileNumber" name="mobileNumber" placeholder="Enter Mobile Number" value="">
                            <div class="invalid-feedback" style="display: block!important;">
                                @error('mobileNumber')
                                    {{ $message }}
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="referenceNumber">Reference Number</label>
                            <input type="text" class="form-control" id="referenceNumber" name="referenceNumber" placeholder="Enter Reference Number" value="">
                            <div class="invalid-feedback" style="display: block!important;">
                                @error('referenceNumber')
                                    {{ $message }}
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="transferAmount">Transfer Amount</label>
                            <input type="text" class="form-control" id="transferAmount" name="transferAmount" placeholder="Enter Transfer Amount" value="">
                            <div class="invalid-feedback" style="display: block!important;">
                                @error('transferAmount')
                                    {{ $message }}
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="transferMode">Transfer Mode</label>
                            <input type="text" class="form-control" id="transferMode" name="transferMode" placeholder="Enter Transfer Mode" value="">
                            <div class="invalid-feedback" style="display: block!important;">
                                @error('transferMode')
                                    {{ $message }}
                                @enderror
                            </div>
                        </div>

                        <div class="form-group text-center" style="margin-top: 29px;">
                            <button class="btn btn-primary">Send Request</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@include('user/footer')

<!-- Success Modal -->
@if(session('success'))
    <div class="modal fade" id="successModal" tabindex="-1" role="dialog" aria-labelledby="successModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title" id="successModalLabel">Success</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>{{ session('success')['message'] }}</p>
                    <p><strong>Payout Ref:</strong> {{ session('success')['data']['payout_ref'] }}</p>
                    <p><strong>Bank Ref:</strong> {{ session('success')['data']['bank_ref'] }}</p>
                </div>
            </div>
        </div>
    </div>
@endif

<!-- Error Modal -->
@if(session('error'))
    <div class="modal fade" id="errorModal" tabindex="-1" role="dialog" aria-labelledby="errorModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title" id="errorModalLabel">Error</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>{{ session('error')['message'] }}</p>
                    <p><strong>Payout Ref:</strong> {{ session('error')['data']['payout_ref'] }}</p>
                    <p><strong>Bank Ref:</strong> {{ session('error')['data']['bank_ref'] }}</p>
                </div>
            </div>
        </div>
    </div>
@endif

<!-- Pending Modal -->
@if(session('pending'))
    <div class="modal fade" id="pendingModal" tabindex="-1" role="dialog" aria-labelledby="pendingModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header bg-warning text-white">
                    <h5 class="modal-title" id="pendingModalLabel">Pending</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>{{ session('pending')['message'] }}</p>
                    <p><strong>Payout Ref:</strong> {{ session('pending')['data']['payout_ref'] }}</p>
                </div>
            </div>
        </div>
    </div>
@endif

<script>
    $(document).ready(function(){
        @if(session('success'))
            $('#successModal').modal('show');
        @endif

        @if(session('error'))
            $('#errorModal').modal('show');
        @endif

        @if(session('pending'))
            $('#pendingModal').modal('show');
        @endif
    });
</script>
