@include('staff/header')

<!-- Page Container START -->

<div class="page-container">

    <!-- Content Wrapper START -->

    <div class="main-content"> 

        <div class="row">
            <div class="col-lg-12">
                <div class="horizontal-form">
                    <form action="{{ url('/staff/pending-transactions') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group row">
                            <div class="col-md-6 mb-6">
                                <input id="date" type="date" class="form-control" name="txndate" value="{{$today}}">
                            </div>

                            <div class="col-md-2  mb-2">
                                <div class="form-group text-left">
                                    <button type="submit" class="btn btn-md btn-primary">View</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="row">

            <div class="col-md-12 col-lg-12">

                <div class="card">

                    <div class="card-body">

                        @if(session('success'))

                            <div class="alert alert-success mb-1 mt-1">

                                {{ session('success') }}

                            </div>

                        @endif

                        <div class="d-flex justify-content-between align-items-center">

                            <h5>Pending Report</h5>                                        

                        </div>

                        <div class="m-t-30">

                            <div class="table-responsive">

                                <table class="table table-hover table-bordered" id="datatable">

                                    <thead>

                                        <tr>
                                            <th>Created At</th>
                                            <th>Txn Id</th> 
                                            <th>Orderid</th> 
                                            <th>Amount</th>
                                            <th>Status</th>                                           
                                            <th>Action</th>
                                        </tr>

                                    </thead>

                                    <tbody>
                                        @if (!empty($PayoutData))
                                            @foreach ($PayoutData as $rows)
                                            <tr>
                                                <td>{{$rows->user->created_at}}</td>
                                                <td>{{$rows->txnId}}</td>                                                 
                                                <td>{{$rows->orderId }}</td>                                                 
                                                <td>{{$rows->amount}}</td>     
                                                <td>{{$rows->status}}</td>     
                                                <td></td>                                                                                                                                             
                                            </tr>                                            
                                            @endforeach
                                        @endif
                                    </tbody>

                                </table>

                                

                            </div>

                            {{-- {{$usertransaction->links()}} --}}

                        </div>

                    </div>

                </div>

            </div>

            

        </div>

    </div>

    <!-- Content Wrapper END -->

    <!-- model -->

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>

    <link href="https://cdn.datatables.net/v/dt/dt-1.13.5/datatables.min.css" rel="stylesheet">

    <script src="https://cdn.datatables.net/v/dt/dt-1.13.5/datatables.min.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>

    <script type="text/javascript">
    $(document).ready(function () {
        let dataTable = new DataTable('#datatable', {
            ordering: false,
            dom: 'Bfrtip',
            buttons: [
                'csv', 'excel', 'pdf'
            ]
        });
    });
</script>


@include('staff/footer')