<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Home;
use App\Http\Controllers\Login;
use App\Http\Controllers\Users;
use App\Http\Controllers\Admin;
use App\Http\Controllers\Staff;
use App\Http\Controllers\Agent;
use App\Http\Controllers\SubAdmin;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/docs', function () {
    return view('welcome');
});

Route::get('/', [Login::class, 'index']);

Route::get('/login', [Login::class, 'index'])->name('login');
Route::post('/authentication', [Login::class, 'verifyUserAuth']);
Route::get('/logout', [Login::class, 'logout'])->name('logout');
Route::match(['get', 'post'], '/verify-otp', [Login::class, 'verifyOtp'])->name('verify-otp');
Route::post('/send-otp', [Login::class, 'sendOtpLogin'])->name('send-otp');
Route::get('/mpingeneration-pin/{id?}', [Login::class, 'generateMpin'])->name('generate-pin/{id?}');

Route::middleware(['auth', 'checkStatus'])->group(function () {

    Route::get('/admin/dashboard', [Admin::class, 'index'])->middleware(['web','isAdmin']);
    Route::match(['get', 'post'], '/admin/change-password', [Admin::class, 'changePassword'])->name('change-password')->middleware(['web','isAdmin']);
    Route::get('/admin/view-profile', [Admin::class, 'viewProfile'])->middleware(['web','isAdmin']);
    Route::get('/admin/manage-users', [Admin::class, 'manageUsers'])->name('manage-users')->middleware(['web','isAdmin']);
    Route::match(['get', 'post'], '/admin/add-user', [Admin::class, 'addUsers'])->name('add-user')->middleware(['web','isAdmin']);
    Route::get('/admin/manage-staff', [Admin::class, 'manageStaff'])->name('manage-staff')->middleware(['web','isAdmin']);
    Route::get('/admin/manage-agent', [Admin::class, 'manageAgent'])->name('manage-agent')->middleware(['web','isAdmin']);
    Route::match(['get', 'post'], '/admin/add-staff', [Admin::class, 'addStaff'])->name('add-staff')->middleware(['web','isAdmin']);
    Route::match(['get', 'post'], '/admin/add-agent', [Admin::class, 'addAgent'])->name('add-agent')->middleware(['web','isAdmin']);
    
    Route::post('/admin/update-users-status', [Admin::class, 'manageUsersStatus'])->name('manage-users-status')->middleware(['web','isAdmin']);
    Route::post('/admin/update-users-bank', [Admin::class, 'manageUsersBank'])->name('manage-users-bank')->middleware(['web','isAdmin']);
    Route::post('/admin/reset-users-password', [Admin::class, 'resetUserPassword'])->name('reset-users-password')->middleware(['web','isAdmin']);
    Route::match(['get', 'post'], '/admin/manage-user-charge/{id?}', [Admin::class, 'manageUserCharge'])->name('/admin/manage-user-charge/{id?}')->middleware(['web','isAdmin']);
    Route::post('/admin/save-user-charge', [Admin::class, 'saveUserCharge'])->name('/admin/save-user-charge')->middleware(['web','isAdmin']);
    Route::post('/admin/save-user-comm', [Admin::class, 'saveUserCommission'])->name('/admin/save-user-comm')->middleware(['web','isAdmin']);
    Route::post('/admin/save-user-ip', [Admin::class, 'saveUserIP'])->name('/admin/save-user-ip')->middleware(['web','isAdmin']);
    Route::post('/admin/save-user-platform-charge', [Admin::class, 'saveUserPlatformCharge'])->name('/admin/save-user-platform-charge')->middleware(['web','isAdmin']);
    Route::post('/admin/save-user-setting', [Admin::class, 'saveUserSetting'])->name('/admin/save-user-setting')->middleware(['web','isAdmin']);
    Route::post('/admin/update-user-authcode', [Admin::class, 'updateUserCode'])->name('/admin/update-user-authcode');
    Route::post('/admin/update-user-fund', [Admin::class, 'updateUserFund'])->name('/admin/update-user-fund');
    Route::get('/admin/wallet-report', [Admin::class, 'walletReport'])->name('admin/wallet-report');
    Route::match(['get', 'post'], '/admin/wallet-report-data', [Admin::class, 'walletReportData'])->name('/admin/wallet-report-data');
    Route::get('/admin/payout-report', [Admin::class, 'payoutReport'])->name('admin/payout-report');
    Route::match(['get', 'post'], '/admin/payout-report-data', [Admin::class, 'payoutReportData'])->name('/admin/payout-report-data');
    Route::match(['get', 'post'], '/admin/wallet-topup', [Admin::class, 'WalletTopup'])->name('/admin/wallet-topup');
    Route::match(['get', 'post'], '/admin/wallet-topup-request', [Admin::class, 'WalletTopupRequest'])->name('/admin/wallet-topup-request');
    Route::match(['get', 'post'], '/admin/wallet-topup-search', [Admin::class, 'WalletTopupSearch'])->name('/admin/wallet-topup-search');
    Route::match(['get', 'post'], '/admin/wallet-topup-report', [Admin::class, 'WalletTopupReport'])->name('/admin/wallet-topup-report');
    Route::match(['get', 'post'], '/admin/manage-staff-ip/{id?}', [Admin::class, 'manageStaffIp'])->name('/admin/manage-staff-ip/{id?}')->middleware(['web','isAdmin']);
    Route::match(['get', 'post'], '/admin/save-satff-ip', [Admin::class, 'addStaffIp'])->name('/admin/save-satff-ip')->middleware(['web','isAdmin']);
    Route::match(['get', 'post'], '/admin/check-pending-status', [Admin::class, 'checkPendingStatus'])->name('/admin/check-pending-status');
    

    // Route::match(['get', 'post'], '/admin/bulk-payout', [Admin::class, 'bulkPayout'])->name('/admin/bulk-payout')->middleware(['web','isAdmin']);
    Route::match(['get', 'post'], '/admin/money/transfer', [Admin::class, 'moneyTransfer'])->name('admin.money.transfer')->middleware(['web','isAdmin']);
    Route::match(['get', 'post'], '/admin/aeps/report', [Admin::class, 'aepsReport'])->name('admin.aeps.report')->middleware(['web','isAdmin']);
    Route::match(['get', 'post'], '/admin/recharge', [Admin::class, 'recharge'])->name('admin.recharge')->middleware(['web','isAdmin']);
    

    Route::match(['get', 'post'], '/admin/wallet-report-export', [Admin::class, 'walletReportDataExport'])->name('/admin/wallet-report-export');
    Route::match(['get', 'post'], '/admin/payout-report-export', [Admin::class, 'payoutReportDataExport'])->name('/admin/payout-report-export');
    Route::match(['get', 'post'], '/admin/topup-report-wallet', [Admin::class, 'topupReportDataExport'])->name('/admin/topup-report-wallet');

    Route::match(['get', 'post'], '/admin/read-csv', [Admin::class, 'readCSV'])->name('/admin/read-csv')->middleware(['web','isAdmin']);
    Route::match(['get', 'post'], '/admin/read-csv-save', [Admin::class, 'datasavepre'])->name('/admin/read-csv-save')->middleware(['web','isAdmin']);
    Route::match(['get', 'post'], '/admin/get-daily-data', [Admin::class, 'getDailyData'])->name('/admin/get-daily-data')->middleware(['web','isAdmin']);
    Route::match(['get', 'post'], '/admin/get-payout-status', [Admin::class, 'getPayoutData'])->name('/admin/get-payout-status')->middleware(['web','isAdmin']);
    
     Route::match(['get', 'post'], '/admin/refund', [Admin::class, 'refund'])->name('/admin/refund')->middleware(['web','isAdmin']);
     
          Route::match(['get', 'post'], '/admin/updatestatus', [Admin::class, 'updatestatus'])->name('/admin/updatestatus');

    Route::get('/user/dashboard', [Users::class, 'index'])->name('user/dashboard');
    Route::match(['get', 'post'], '/user/change-password', [Users::class, 'changePassword'])->name('user/change-password');
    Route::get('/user/view-profile', [Users::class, 'viewProfile']);
    Route::get('/user/wallet-report', [Users::class, 'walletReport'])->name('user/wallet-report');
    Route::match(['get', 'post'], '/user/add-bank-account', [Users::class, 'addBankAccount'])->name('/user/add-bank-account');
    Route::match(['get', 'post'], '/user/wallet-report-data', [Users::class, 'walletReportData'])->name('/user/wallet-report-data');

    Route::match(['get', 'post'], '/user/wallet-report-export', [Users::class, 'walletReportDataExport'])->name('/user/wallet-report-export');
    Route::match(['get', 'post'], '/user/payout-report-export', [Users::class, 'payoutReportDataExport'])->name('/user/payout-report-export');
    Route::match(['get', 'post'], '/user/topup-report-export', [Users::class, 'topupReportDataExport'])->name('/user/topup-report-export');

    Route::get('/user/payout-report', [Users::class, 'payoutReport'])->name('user/payout-report');
    Route::match(['get', 'post'], '/user/payout-report-data', [Users::class, 'payoutReportData'])->name('/user/payout-report-data');
    Route::get('/user/wallet-topup-report', [Users::class, 'walletTopupReport'])->name('user/wallet-topup-report');
    Route::match(['get', 'post'], '/user/wallet-topup-report-data', [Users::class, 'walletTopupReportData'])->name('/user/wallet-topup-report-data');
    Route::match(['get', 'post'], '/user/dev-setting', [Users::class, 'devSetting'])->name('/user/dev-setting');
    Route::match(['get', 'post'], '/user/api-docs', [Users::class, 'apiDocs'])->name('/user/api-docs');
    Route::match(['get', 'post'], '/user/generate-link', [Users::class, 'generatePaymentLink'])->name('/user/generate-link');
    Route::match(['get', 'post'], '/user/wallet-topup', [Users::class, 'wallettopup'])->name('/user/wallet-topup');
    Route::match(['get', 'post'], '/user/user-payin', [Users::class, 'userPayin'])->name('/user/user-payin');
    
    Route::match(['get', 'post'], '/user/money/transfer', [Users::class, 'moneyTransfer'])->name('user.money.transfer');
    Route::match(['get', 'post'], '/user/aeps/report', [Users::class, 'aepsReport'])->name('user.aeps.report');
    Route::match(['get', 'post'], '/user/recharge', [Users::class, 'recharge'])->name('user.recharge');


    Route::get('/staff/dashboard', [Staff::class, 'index'])->name('staff/dashboard')->middleware(['web','isStaff']);
    Route::match(['get', 'post'], '/staff/change-password', [Staff::class, 'changePassword'])->name('staff/change-password')->middleware(['web','isStaff']);
    Route::get('/staff/view-profile', [Staff::class, 'viewProfile'])->middleware(['web','isStaff']);
    Route::get('/staff/wallet-report', [Staff::class, 'walletReport'])->name('staff/wallet-report')->middleware(['web','isStaff']);
    Route::get('/staff/payout-report', [Staff::class, 'payoutReport'])->name('staff/payout-report')->middleware(['web','isStaff']);
    Route::match(['get', 'post'], '/staff/wallet-topup', [Staff::class, 'WalletTopup'])->name('/staff/wallet-topup')->middleware(['web','isStaff']);
    Route::match(['get', 'post'], '/staff/wallet-topup-request', [Staff::class, 'WalletTopupRequest'])->name('/staff/wallet-topup-request')->middleware(['web','isStaff']);
    Route::match(['get', 'post'], '/staff/wallet-topup-search', [Staff::class, 'WalletTopupSearch'])->name('/staff/wallet-topup-search')->middleware(['web','isStaff']);
    Route::match(['get', 'post'], '/staff/wallet-topup-report', [Staff::class, 'WalletTopupReport'])->name('/staff/wallet-topup-report')->middleware(['web','isStaff']);
    Route::match(['get', 'post'], '/staff/topup-report-export', [Staff::class, 'topupReportDataExport'])->name('/admin/topup-report-export')->middleware(['web','isStaff']);
    Route::match(['get', 'post'], '/staff/pending-transactions', [Staff::class, 'PendingTrancations'])->name('/admin/pending-transactions')->middleware(['web','isStaff']);
    Route::match(['get', 'post'], '/staff/pending-check-txn', [Staff::class, 'PendingTrancationsCheck'])->name('/staff/pending-check-txn')->middleware(['web','isStaff']);
    Route::match(['get', 'post'], '/staff/check-pending-status', [Staff::class, 'checkPendingStatus'])->name('/staff/check-pending-status')->middleware(['web','isStaff']);
    Route::match(['get', 'post'], '/staff/whitelisted-account', [Staff::class, 'whiteListedAccount'])->name('/staff/whitelisted-account')->middleware(['web','isStaff']);
    Route::match(['get', 'post'], '/staff/add-bank-account', [Staff::class, 'addBankAccount'])->name('/staff/add-bank-account');
     Route::match(['get', 'post'], '/staff/updatestatus', [Staff::class, 'updateaccountstatus'])->name('/staff/updatestatus');
   
    Route::get('/agent/dashboard', [Agent::class, 'index'])->name('agent/dashboard');
    Route::get('/agent/users', [Agent::class, 'usersData'])->name('agent/users');
    Route::get('/agent/wallet-report', [Agent::class, 'walletReport'])->name('agent/wallet-report');
    Route::match(['get', 'post'], '/agent/wallet-report-data', [Agent::class, 'walletReportData'])->name('/agent/wallet-report-data');
    Route::get('/agent/payout-report', [Agent::class, 'payoutReport'])->name('agent/payout-report');
    Route::match(['get', 'post'], '/agent/payout-report-data', [Agent::class, 'payoutReportData'])->name('/agent/payout-report-data');
    Route::get('/agent/wallet-topup-report', [Agent::class, 'walletTopupReport'])->name('agent/wallet-topup-report');
    Route::match(['get', 'post'], '/agent/topup-report-export', [Agent::class, 'topupReportDataExport'])->name('/agent/topup-report-export');
    Route::match(['get', 'post'], '/agent/change-password', [Agent::class, 'changePassword'])->name('agent/change-password');

    Route::get('/sub-admin/dashboard', [SubAdmin::class, 'index'])->name('sub-admin/dashboard');
    Route::match(['get', 'post'], '/sub-admin/change-password', [SubAdmin::class, 'changePassword'])->name('sub-admin/change-password');
    Route::get('/sub-admin/view-profile', [SubAdmin::class, 'viewProfile']);
    //Route::match(['get', 'post'], '/subadmin/add-user', [SubAdmin::class, 'addUser'])->name('subadmin/add-user');
    Route::get('/sub-admin/manage-users', [SubAdmin::class, 'manageUsers'])->name('sub-admin/manage-users');
    Route::post('/sub-admin/update-users-status', [SubAdmin::class, 'manageUsersStatus'])->name('sub-admin/manage-users-status');
    Route::get('/sub-admin/payout-report', [SubAdmin::class, 'payoutReport'])->name('sub-admin/payout-report');
    Route::match(['get', 'post'], '/sub-admin/payout-report-data', [SubAdmin::class, 'payoutReportData'])->name('/sub-admin/payout-report-data');
    Route::match(['get', 'post'], '/sub-admin/payout-report-export', [SubAdmin::class, 'payoutReportDataExport'])->name('/sub-admin/payout-report-export');
    Route::get('/sub-admin/wallet-report', [SubAdmin::class, 'walletReport'])->name('sub-admin/wallet-report');
    Route::match(['get', 'post'], '/sub-admin/wallet-report-data', [SubAdmin::class, 'walletReportData'])->name('/sub-admin/wallet-report-data');
    Route::match(['get', 'post'], '/sub-admin/wallet-report-export', [SubAdmin::class, 'walletReportDataExport'])->name('/sub-admin/wallet-report-export');

});

