<?php echo $__env->make('staff/header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Page Container START -->

<div class="page-container">

    <!-- Content Wrapper START -->

    <div class="main-content"> 

        <div class="row">

            <div class="col-lg-12">

                <div class="horizontal-form">

                    <form action="<?php echo e(url('/staff/whitelisted-account')); ?>" method="POST" enctype="multipart/form-data">

                        <?php echo csrf_field(); ?>

                        <div class="form-group row">

                            <div class="col-md-4 mb-2">

                                <select class="form-select form-control" aria-label="Default select example" name="user" require>

                                    <!-- <option value="">Select user</option> -->

                                    <?php if(!empty($users)): ?>

                                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rows): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                            <option value="<?php echo e($rows->id); ?>"><?php echo e($rows->name); ?></option>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                                    

                                    <?php endif; ?>

                                </select>

                            </div>

                            

                            <div class="col-md-2  mb-2">

                                <div class="form-group text-left">

                                    <button type="submit" class="btn btn-md btn-success">View</button>

                                </div>

                            </div>

                        </div>

                    </form>

                </div>

            </div>

        </div>

        <div class="row">

            <div class="col-md-12 col-lg-12">

                <div class="card">

                    <div class="card-body">

                        <?php if(session('success')): ?>

                            <div class="alert alert-success mb-1 mt-1">

                                <?php echo e(session('success')); ?>


                            </div>

                        <?php endif; ?>

                        <div class="d-flex justify-content-between align-items-center">

                            <h5>Whitelisted Account</h5>                                        

                        </div>
                        <div class="m-t-30">
                            <div class="table-responsive">
                                <table class="table table-hover table-bordered" id="datatable">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Status</th>                                            
                                        </tr>
                                    </thead>
                                    <tbody>
                                    <?php if(!empty($BankAccount)): ?>

                                        <?php $__currentLoopData = $BankAccount; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rows): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <tr>                                                                                                                                                                             
                                            <td><?php echo e($rows->beneName); ?></td>                                                                                                 
                                            <td>
                                                <?php if($rows->status == 1): ?>
                                                    <button class="btn btn-sm btn-success" disabled>
                                                        Approved
                                                    </button>
                                                <?php else: ?>
                                                    <!--<button class="btn btn-sm btn-danger">-->
                                                    <!--PENDING-->
                                                    <!--</button>-->
                                                    
                                                      <button id="pendingBtn<?php echo e($rows->id); ?>" class="btn btn-sm btn-danger" onclick="approveAccount(<?php echo e($rows->id); ?>)">
                            PENDING
                        </button>
                    
                     <button class="btn btn-sm btn-primary" onclick="viewDocuments('<?php echo e(asset('public/uploads/' . $rows->pancard)); ?>', '<?php echo e(asset('public/uploads/' . $rows->addhaarFront)); ?>', '<?php echo e(asset('public/uploads/' . $rows->cancelCheque)); ?>', '<?php echo e(asset('public/uploads/' . $rows->addhaarBank)); ?>')">
                        View Documents
                    </button>
                                                <?php endif; ?>

                                            </td>   
                                           

                                        </tr>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Content Wrapper END -->

    <!-- model -->

    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">

    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.1.1/css/buttons.dataTables.min.css">

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>

    <script src="https://cdn.datatables.net/buttons/2.1.1/js/dataTables.buttons.min.js"></script>

    <script src="https://cdn.datatables.net/buttons/2.1.1/js/buttons.html5.min.js"></script>

    



<script type="text/javascript">

    $(document).ready(function () {

        let dataTable = new DataTable('#datatable', {

            ordering: false,

            dom: 'Bfrtip',

            buttons: [

                'csv', 'excel', 'pdf'

            ]

        });

    });
    
    
      function approveAccount(accountId) {
        // Send an AJAX request to update the status
        
         var url = '<?php echo e(url('/staff/updatestatus')); ?>';
         
        $.ajax({
            url: url, // Replace this with your route URL for updating status
            type: 'POST',
            data: {
                accountId: accountId,
                _token: '<?php echo e(csrf_token()); ?>' // Include CSRF token for Laravel
            },
            success: function(response) {
                // Update the button text and class if the status was successfully updated
                if (response.success) {
                    $('#pendingBtn' + accountId).removeClass('btn-danger').addClass('btn-success').text('Approved');
                }
            },
            error: function(xhr, status, error) {
                console.error(error); // Log any errors to the console
            }
        });
    }
    
    function viewDocuments(pancardUrl, aadharcardUrl, cancelchequeUrl, aadharbankUrl) {
        var newTab = window.open('', '_blank');
        newTab.document.write('<html><head><title>Documents</title></head><body>');
        newTab.document.write('<h1>PAN Card</h1><img src="' + pancardUrl + '"><br>');
        newTab.document.write('<h1>Aadhar Card</h1><img src="' + aadharcardUrl + '"><br>');
        newTab.document.write('<h1>Cancel Cheque</h1><img src="' + cancelchequeUrl + '"><br>');
        newTab.document.write('<h1>Aadhar Bank</h1><img src="' + aadharbankUrl + '"><br>');
        newTab.document.write('</body></html>');
        newTab.document.close();
    }

</script>



<?php echo $__env->make('staff/footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/resources/views/staff/whitelisted-account.blade.php ENDPATH**/ ?>