<?php echo $__env->make('staff/header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Page Container START -->

<div class="page-container">

    <!-- Content Wrapper START -->

    <div class="main-content"> 

        <div class="row">
            <div class="col-lg-12">
                <div class="horizontal-form">
                    <form action="<?php echo e(url('/staff/pending-transactions')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="form-group row">
                            <div class="col-md-6 mb-6">
                                <input id="date" type="date" class="form-control" name="txndate" value="<?php echo e($today); ?>">
                            </div>

                            <div class="col-md-2  mb-2">
                                <div class="form-group text-left">
                                    <button type="submit" class="btn btn-md btn-primary">View</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="row">

            <div class="col-md-12 col-lg-12">

                <div class="card">

                    <div class="card-body">

                        <?php if(session('success')): ?>

                            <div class="alert alert-success mb-1 mt-1">

                                <?php echo e(session('success')); ?>


                            </div>

                        <?php endif; ?>

                        <div class="d-flex justify-content-between align-items-center">

                            <h5>Pending Report</h5>                                        

                        </div>

                        <div class="m-t-30">

                            <div class="table-responsive">

                                <table class="table table-hover table-bordered" id="datatable">

                                    <thead>

                                        <tr>
                                            <th>Created At</th>
                                            <th>Txn Id</th> 
                                            <th>Orderid</th> 
                                            <th>Amount</th>
                                            <th>Status</th>                                           
                                            <th>Action</th>
                                        </tr>

                                    </thead>

                                    <tbody>
                                        <?php if(!empty($PayoutData)): ?>
                                            <?php $__currentLoopData = $PayoutData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rows): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($rows->created_at); ?></td>
                                                <td><?php echo e($rows->txnId); ?></td>                                                 
                                                <td><?php echo e($rows->orderId); ?></td>                                                 
                                                <td><?php echo e($rows->amount); ?></td>     
                                                <td><?php echo e($rows->status); ?></td>     
                                                <td>
                                                    <button class="btn btn-primary" onClick="checkTxnStatus('<?php echo e($rows->txnId); ?>');">Check Status</button>
                                                </td>                                                                                                                                             
                                            </tr>                                            
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </tbody>

                                </table>

                                

                            </div>

                            

                        </div>

                    </div>

                </div>

            </div>

            

        </div>

    </div>

    <!-- Content Wrapper END -->

    <!-- model -->

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>

    <link href="https://cdn.datatables.net/v/dt/dt-1.13.5/datatables.min.css" rel="stylesheet">

    <script src="https://cdn.datatables.net/v/dt/dt-1.13.5/datatables.min.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>

    <script type="text/javascript">
    $(document).ready(function () {
        let dataTable = new DataTable('#datatable', {
            ordering: false,
            dom: 'Bfrtip',
            buttons: [
                'csv', 'excel', 'pdf'
            ]
        });
    });
</script>

<script>

    function checkTxnStatus(txnId)
    {
        var csrfToken = $('meta[name="csrf-token"]').attr('content');
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': csrfToken
            }
        });
        var url = '<?php echo e(url('/staff/pending-check-txn')); ?>';
        $.ajax({

            type: 'POST',
            url: url,
            data: {
                'txnId':txnId,
            },

            success: function (response) {
               alert(response);
               //location.reload();
            }
        });
    }

</script>


<?php echo $__env->make('staff/footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/resources/views/staff/pendingTxn.blade.php ENDPATH**/ ?>